/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import th.co.oga.security.pki.Transport.EmailAuthenticator;
import th.co.oga.security.pki.Transport.ProtocolProperties;
import th.co.oga.security.pki.Transport.SMTPTrnsSPEC;
import th.co.oga.security.pki.Transport.TransportConnector;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackage;
import th.co.oga.security.pki.Transport.TransportPackageLoadingException;
import th.co.oga.security.pki.Transport.UnSupportProtocolPropertyException;

public class SMTPConnector
implements SMTPTrnsSPEC,
TransportConnector {
    private Properties props;
    private URLName url;
    private Session session;
    private Transport trns;
    private Message msg;
    private int state = 0;
    private boolean avariable = true;

    public SMTPConnector() {
    }

    public SMTPConnector(String url) throws IOException {
        this(null, url);
    }

    public SMTPConnector(java.net.PasswordAuthentication authen, String url) throws IOException {
        this();
        this.open(authen, url, true, true);
    }

    public void open(java.net.PasswordAuthentication authen, String destination, boolean readable, boolean writable) throws IOException {
        this.url = new URLName(destination);
        this.props = System.getProperties();
        this.props.put("mail.transport.protocol", this.url.getProtocol());
        this.props.put("mail.smtp.host", this.url.getHost());
        this.session = Session.getDefaultInstance((Properties)this.props, (Authenticator)new EmailAuthenticator());
        try {
            this.trns = this.session.getTransport(this.url);
            this.trns.connect();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.setAuthen(authen);
        this.msg = new MimeMessage(this.session);
        this.setSender(String.valueOf(this.url.getUsername()) + "@" + this.url.getHost());
    }

    public void close() {
        if (this.trns.isConnected()) {
            try {
                this.trns.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void lock() {
        this.avariable = false;
    }

    public void receive(TransportPackage pkg) throws IOException {
    }

    public void release() {
        this.avariable = true;
    }

    public void send(TransportPackage pkg) throws IOException {
    }

    public void setAuthen(java.net.PasswordAuthentication authenToken) {
        if (authenToken != null) {
            PasswordAuthentication mpa = new PasswordAuthentication(authenToken.getUserName(), new String(authenToken.getPassword()));
            this.session.setPasswordAuthentication(this.url, mpa);
            try {
                this.trns = this.session.getTransport(this.url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setTraceMode(boolean tracing) {
        this.session.setDebug(tracing);
    }

    public void setContentType(String contentType) throws IllegalArgumentException {
        try {
            this.msg.setHeader("Content-type", contentType);
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void setMethod(String method) throws ProtocolException {
    }

    public void multipartRequest(TransportPackage req, TransportPackage res) throws IOException {
        try {
            TransportHeader hdr = req.getHeader();
            this.msg.setSubject(hdr.getSubject());
            this.loadPackage(req);
            this.send();
        }
        catch (MessagingException e) {
            throw new TransportPackageLoadingException((Exception)((Object)e));
        }
    }

    public void inLineRequest(TransportPackage req, TransportPackage res) throws IOException, TransportPackageLoadingException {
        try {
            TransportHeader hdr = req.getHeader();
            this.msg.setHeader("Content-type", req.getContentType());
            this.msg.setSubject(hdr.getSubject());
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            req.encode(buffer, TransportEncodeFormat.PEM);
            this.msg.setText(buffer.toString());
            this.send();
        }
        catch (MessagingException e) {
            throw new TransportPackageLoadingException((Exception)((Object)e));
        }
    }

    public void loadPackage(TransportPackage pkg) throws IOException, MessagingException {
        TransportHeader hdr = pkg.getHeader();
        MimeMultipart mp = null;
        try {
            Object obj = this.msg.getContent();
            if (obj instanceof Multipart) {
                mp = (Multipart)obj;
            } else if (obj instanceof String) {
                MimeBodyPart text = new MimeBodyPart();
                mp.addBodyPart((BodyPart)text);
            }
        }
        catch (IOException e) {
            mp = new MimeMultipart();
        }
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler((DataSource)pkg));
        mbp.setFileName(hdr.getFileName());
        mp.addBodyPart((BodyPart)mbp);
        this.msg.setContent((Multipart)mp);
    }

    public void send() throws MessagingException {
        Transport.send((Message)this.msg);
    }

    public void setSubject(String subject) throws MessagingException {
        this.msg.setSubject(subject);
    }

    public void setTo(String address) throws MessagingException, AddressException {
        this.msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(address));
    }

    public void setCC(String address) throws MessagingException, AddressException {
        this.msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(address));
    }

    public void addRecipient(String recipientAddress) throws IllegalArgumentException {
        try {
            this.setTo(recipientAddress);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Recipient  Email Address");
        }
    }

    public void setSender(String senderAddress) throws IllegalArgumentException {
        try {
            Address[] addrs = new Address[]{new InternetAddress(senderAddress)};
            this.msg.addFrom(addrs);
            this.msg.setReplyTo(addrs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Sender Email Address");
        }
    }

    public void setText(String text) throws MessagingException {
        this.msg.setText(text);
    }

    public void attachFile(String attachFile) throws MessagingException, IOException {
        Multipart mp;
        Object obj = this.msg.getContent();
        if (obj instanceof Multipart) {
            mp = (Multipart)obj;
        } else {
            System.out.println("The Object is :" + obj);
            mp = new MimeMultipart();
            if (obj instanceof String) {
                MimeBodyPart text = new MimeBodyPart();
                text.setText((String)obj);
                mp.addBodyPart((BodyPart)text);
            }
        }
        MimeBodyPart mbp = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(attachFile);
        mbp.setDataHandler(new DataHandler((DataSource)fds));
        mbp.setFileName(fds.getName());
        mp.addBodyPart((BodyPart)mbp);
        this.msg.setContent(mp);
    }

    public void setProps(ProtocolProperties props) throws UnSupportProtocolPropertyException {
    }
}

