/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.util.HashMap;
import java.util.Properties;
import th.co.oga.security.pki.Transport.TransportMimeType;
import th.co.oga.security.pki.Transport.TransportProtocol;

public class TransportHeader
extends HashMap {
    private TransportProtocol protocol;
    private String contentType = "text/html";
    private String fileName = null;
    private String name = null;
    private String subject = null;
    private boolean completed = false;
    private int statusNo = 0;
    private String statusText = "";
    private long lastModified = 0L;
    private int contentLength = 0;
    private String encoding;
    private Properties reqParams = new Properties();

    public TransportHeader() {
    }

    public TransportHeader(TransportProtocol protocol) {
        this();
        this.protocol = protocol;
    }

    public void set(TransportHeader org) {
        this.contentType = org.getContentType();
        this.fileName = org.getFileName();
        this.name = org.getName();
        this.subject = org.getSubject();
        this.completed = org.getStatus();
        this.statusNo = org.getStatusNo();
        this.statusText = org.getStatusText();
        this.lastModified = org.getLastModified();
        this.contentLength = org.getContentLength();
        this.encoding = org.getEncoding();
        this.putAll(org);
    }

    public TransportHeader(TransportMimeType mimeType) {
        this.contentType = mimeType.getMimeType();
    }

    public void setLastModify(long modifyTime) {
        this.lastModified = modifyTime;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setStatus(boolean status) {
        this.completed = status;
    }

    public void setStatusText(String message) {
        this.statusText = message;
    }

    public void setStatusNumber(int statusNo) {
        this.statusNo = statusNo;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRequestParam(String key, String value) {
        this.reqParams.setProperty(key, value);
    }

    public Properties getRequestParam() {
        return this.reqParams;
    }

    public void setParameter(String key, Object value) {
        if (key != null) {
            this.put(key, value);
        }
    }

    public Object getParameter(String key) {
        return this.get(key);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean getStatus() {
        return this.completed;
    }

    public int getStatusNo() {
        return this.statusNo;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public String getSubject() {
        return this.subject;
    }
}

