/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Transport;

import java.io.IOException;
import th.co.oga.security.pki.Transport.HTTPConnector;
import th.co.oga.security.pki.Transport.InvalidProtocolNameException;
import th.co.oga.security.pki.Transport.ProtocolProperties;
import th.co.oga.security.pki.Transport.SMTPConnector;
import th.co.oga.security.pki.Transport.TransportConnector;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.ProtocolName;

public class TransportProtocol {
    public static String HTTP_PROTOCOL = "HTTP";
    public static String HTTPS_PROTOCOL = "HTTPS";
    public static String LDAP_PROTOCOL = "LDAP";
    public static String LDAPS_PROTOCOL = "LDAPS";
    public static String SMTP_PROTOCOL = "smtp";
    public static TransportProtocol HTTP = new TransportProtocol(HTTP_PROTOCOL, 80, false);
    public static TransportProtocol LDAP = new TransportProtocol(LDAP_PROTOCOL, 378, false);
    public static TransportProtocol HTTPS = new TransportProtocol(HTTPS_PROTOCOL, 443, true);
    public static TransportProtocol LDAPS = new TransportProtocol(LDAPS_PROTOCOL, 375, true);
    public static TransportProtocol SMTP = new TransportProtocol(SMTP_PROTOCOL, 25, false);
    private String name;
    private int port;
    private boolean ssl;

    public TransportProtocol(String name, int port, boolean ssl) {
        this.name = name;
        this.port = port;
        this.ssl = ssl;
    }

    public String getName() {
        return this.name;
    }

    public int getPortNumber() {
        return this.port;
    }

    public boolean getSSLStatus() {
        return this.ssl;
    }

    public TransportProtocol[] getAllProtocolName() {
        return new TransportProtocol[]{HTTP, HTTPS, LDAP, LDAPS, SMTP};
    }

    public static TransportProtocol getProtocol(String pname) throws InvalidProtocolNameException {
        if (pname.equalsIgnoreCase("http")) {
            return HTTP;
        }
        if (pname.equalsIgnoreCase("https")) {
            return HTTPS;
        }
        if (pname.equalsIgnoreCase("ldap")) {
            return LDAP;
        }
        if (pname.equalsIgnoreCase("ldaps")) {
            return LDAPS;
        }
        if (pname.equalsIgnoreCase("smtp")) {
            return SMTP;
        }
        throw new InvalidProtocolNameException(String.valueOf(pname) + " not found in Protocol Supported list.");
    }

    public static TransportConnector getConnector(AuthorityService service) throws UnSupportProtocolException, IOException {
        ProtocolName ptc = service.getProtocol();
        String urlStr = service.getStringUrl();
        ProtocolProperties props = service.getParameters();
        if (HTTP_PROTOCOL.equalsIgnoreCase(ptc.getName())) {
            return new HTTPConnector(service.getAuthen(), urlStr, props);
        }
        if (SMTP_PROTOCOL.equalsIgnoreCase(ptc.getName())) {
            return new SMTPConnector(service.getAuthen(), urlStr);
        }
        throw new UnSupportProtocolException("ProtocolName", String.valueOf(ptc.getName()) + " protocol not support yet");
    }
}

