/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Trusted;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Transport.InvalidProtocolNameException;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.ProtocolName;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class Authority
extends ArrayList
implements XMLRecord {
    private String name;
    private String policyId;
    private ArrayList idx = new ArrayList();
    private boolean registered = false;
    private X500Principal subjectName = null;
    private X500Principal issuerName = null;
    private BigInteger sn;
    private String nicName = null;

    private Authority() {
    }

    public Authority(String name) {
        this();
        this.setName(name);
    }

    public Authority(Node node) throws XMLRecordDataException {
        this();
        this.setXMLRecord(node);
    }

    public Authority(Node node, boolean reged) throws XMLRecordDataException {
        this();
        this.setXMLRecord(node);
        this.registered = reged;
    }

    protected void removeService(AuthorityService service) {
        int pointer = this.idx.indexOf(service.getName());
        if (pointer > -1) {
            this.remove(pointer);
            this.idx.remove(pointer);
        }
    }

    public void setService(AuthorityService service) {
        int pointer = this.idx.indexOf(service.getName());
        if (pointer > -1) {
            this.remove(pointer);
            this.add(pointer, service);
        } else {
            this.idx.add(service.getName());
            this.add(service);
        }
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setSubjectName(X500Principal name) {
        this.subjectName = name;
    }

    private void setIssuerName(X500Principal name) {
        this.issuerName = name;
    }

    private void setSN(BigInteger sn) {
        this.sn = sn;
    }

    private void setSN(String sn) {
        this.sn = new BigInteger(sn);
    }

    public void setPolicyID(String oid) {
        this.policyId = oid;
    }

    public void setNicName(String nic) {
        this.nicName = nic;
    }

    public int getNumberOfService() {
        return this.idx.size();
    }

    public String getServiceNames() {
        String names = "";
        int i = 0;
        while (i < this.idx.size()) {
            if (i > 0) {
                names = String.valueOf(names) + ", ";
            }
            names = String.valueOf(names) + (String)this.idx.get(i);
            ++i;
        }
        return names;
    }

    public String getName() {
        return this.name;
    }

    public String getNicName() {
        return this.nicName;
    }

    public String getPolicyID() {
        return this.policyId;
    }

    public X500Principal getSubjectName() {
        return this.subjectName;
    }

    public X500Principal getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getSN() {
        return this.sn;
    }

    public boolean isServe(ServiceName service) {
        return this.idx.indexOf(service.getName()) > -1;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public AuthorityService getService(ServiceName svc) {
        int pnt = this.idx.indexOf(svc.getName());
        if (pnt > -1) {
            return (AuthorityService)this.get(pnt);
        }
        AuthorityService as = new AuthorityService(svc);
        as.setProtocol(ProtocolName.HTTP);
        this.setService(as);
        return this.getService(svc);
    }

    public AuthorityService findService(ServiceName svc) {
        int pnt = this.idx.indexOf(svc.getName());
        if (pnt > -1) {
            return (AuthorityService)this.get(pnt);
        }
        return null;
    }

    public AuthorityService[] getServices() {
        ServiceName[] sns = ServiceName.getAllServiceName();
        AuthorityService[] ass = new AuthorityService[sns.length];
        int i = 0;
        while (i < sns.length) {
            ass[i] = this.getService(sns[i]);
            ++i;
        }
        return ass;
    }

    public void pack() {
        ServiceName[] sns = ServiceName.getAllServiceName();
        int i = 0;
        while (i < sns.length) {
            AuthorityService as;
            int pnt = this.idx.indexOf(sns[i].getName());
            if (pnt > -1 && !(as = (AuthorityService)this.get(pnt)).verify()) {
                this.removeService(as);
            }
            ++i;
        }
    }

    public static Authority getInstance(CertProfile caCert) throws ASN1Exception {
        String policyId;
        X509Certificate xCer = caCert.getX509Cert();
        Authority authority = new Authority(caCert.getAuthorityName());
        authority.setSubjectName(xCer.getSubjectX500Principal());
        authority.setIssuerName(xCer.getIssuerX500Principal());
        authority.setSN(xCer.getSerialNumber());
        URL crlUrl = caCert.getCRLDistributionPointURL();
        if (crlUrl != null) {
            try {
                AuthorityService crl = authority.getService(ServiceName.CRL);
                crl.setURL(crlUrl);
            }
            catch (InvalidProtocolNameException crl) {
                // empty catch block
            }
        }
        if ((policyId = caCert.getPolicyID()) != null) {
            authority.setPolicyID(policyId);
        }
        return authority;
    }

    public static String getAuthorityName(CertProfile cert) throws ASN1Exception {
        return cert.getAuthorityName();
    }

    public String getElementName() {
        return CryptOGAFormat.CA;
    }

    public String getParentElementName() {
        return CryptOGAFormat.CA_PARENT;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(this.getElementName());
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_NAME, this.getName()));
        if (this.policyId != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_POLICY_ID, this.getPolicyID()));
        }
        if (this.sn != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SN, this.getSN().toString()));
        }
        if (this.nicName != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_NIC_NAME, this.getNicName()));
        }
        if (this.subjectName != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SUBJECTNAME, new String(BASE64EncoderStream.encode((byte[])this.subjectName.getEncoded()))));
        }
        if (this.issuerName != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_ISSUERNAME, new String(BASE64EncoderStream.encode((byte[])this.issuerName.getEncoded()))));
        }
        int i = 0;
        while (i < this.size()) {
            parent.appendChild(((AuthorityService)this.get(i)).getXMLNode(doc));
            ++i;
        }
        return parent;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        Authority a = new Authority(node);
        return this.getName().equals(a.getName());
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("Authority", " Empty node was supplied " + node.toString());
        }
        try {
            boolean subjed = false;
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.CA_NAME)) {
                        this.setName(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_POLICY_ID)) {
                        this.setPolicyID(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SN)) {
                        this.setSN(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_NIC_NAME)) {
                        this.setNicName(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_ISSUERNAME)) {
                        this.issuerName = new X500Principal(BASE64DecoderStream.decode((byte[])nv.getBytes()));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SUBJECTNAME)) {
                        this.subjectName = new X500Principal(BASE64DecoderStream.decode((byte[])nv.getBytes()));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SERVICE)) {
                        this.setService(new AuthorityService(nodeList.item(i)));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLRecordDataException("Authority", e.toString());
        }
    }
}

