/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Trusted;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.PasswordAuthentication;
import java.net.URL;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Transport.InvalidProtocolNameException;
import th.co.oga.security.pki.Transport.ProtocolProperties;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.pki.Trusted.ProtocolName;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.utils.Base64InputStream;
import th.co.oga.security.utils.Base64OutputStream;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class AuthorityService
implements XMLRecord {
    private ServiceName service;
    private ProtocolName protocol;
    private String host;
    private int port;
    private String path;
    private String sender;
    private String recipient;
    private PasswordAuthentication auth;
    private ProtocolProperties params;

    public AuthorityService(ServiceName service) {
        this.setService(service);
    }

    public AuthorityService(ServiceName service, ProtocolName protocol, String host, String path) {
        this(service, protocol, protocol.getPortNumber(), host, path);
    }

    public AuthorityService(ServiceName service, ProtocolName protocol, int port, String host, String path) {
        this.setService(service);
        this.setProtocol(protocol, port);
        this.setHost(host);
        this.setPath(path);
    }

    public AuthorityService(Node node) throws XMLRecordDataException {
        this.setXMLRecord(node);
    }

    public void setURL(URL url) throws InvalidProtocolNameException {
        if (url.getPort() > -1) {
            this.setProtocol(ProtocolName.getInstance(url.getProtocol()), url.getPort());
        } else {
            this.setProtocol(ProtocolName.getInstance(url.getProtocol()));
        }
        this.setHost(url.getHost());
        this.setPath(url.getPath());
    }

    public void setProtocol(ProtocolName protocol) {
        this.setProtocol(protocol, protocol.getPortNumber());
    }

    public void setProtocol(ProtocolName protocol, int port) {
        this.protocol = protocol;
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(String port) {
        this.port = new BigInteger(port).intValue();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setParameter(ProtocolProperties props) throws UnSupportProtocolException {
        this.params = ProtocolProperties.getInstance(this.protocol);
        this.params.setProps(props);
    }

    public void setAuthen(String user, String password) {
        this.auth = new PasswordAuthentication(user, password.toCharArray());
    }

    public void setAuthen(PasswordAuthentication authen) {
        this.auth = authen;
    }

    public void setSender(String addr) {
        this.sender = addr;
    }

    public void setRecipient(String addr) {
        this.recipient = addr;
    }

    protected void setService(ServiceName service) {
        this.service = service;
    }

    protected void setBase64Authen(String str) throws IOException, InvalidBERException {
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        Base64InputStream b64In = new Base64InputStream(in);
        SEQUENCE.Template tp = SEQUENCE.getTemplate();
        tp.addElement((ASN1Template)OCTET_STRING.getTemplate());
        tp.addElement((ASN1Template)OCTET_STRING.getTemplate());
        SEQUENCE seq = (SEQUENCE)tp.decode((InputStream)b64In);
        String user = new String(((OCTET_STRING)seq.elementAt(0)).toByteArray());
        String password = new String(((OCTET_STRING)seq.elementAt(1)).toByteArray());
        this.auth = new PasswordAuthentication(user, password.toCharArray());
    }

    public String getName() {
        return this.service.getName();
    }

    public String getProtocolName() {
        return this.protocol.getName();
    }

    public ProtocolName getProtocol() {
        return this.protocol;
    }

    public String getPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public ProtocolProperties getParameters() {
        return this.params;
    }

    public String getStringUrl() {
        String url = String.valueOf(this.protocol.getName()) + "://" + this.host + ":" + this.port;
        if (this.path != null && this.path.length() > 0) {
            url = this.path.charAt(0) == '/' ? String.valueOf(url) + this.path : String.valueOf(url) + "/" + this.path;
        }
        return url;
    }

    public PasswordAuthentication getAuthen() {
        return this.auth;
    }

    protected String getBase64Authen() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64OutputStream b64Out = new Base64OutputStream(new PrintStream(out));
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)new OCTET_STRING(this.auth.getUserName().getBytes()));
        seq.addElement((ASN1Value)new OCTET_STRING(new String(this.auth.getPassword()).getBytes()));
        b64Out.write(ASN1Util.encode((ASN1Value)seq));
        return new String(out.toByteArray());
    }

    public boolean verify() {
        try {
            Utils.checkNull(this.protocol);
            Utils.checkNull(this.host);
            Utils.checkNull(this.service);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean equals(AuthorityService as) {
        return this.getName().equals(as.getName()) && this.getHost().equals(as.getHost()) && this.getPort() == as.getPort();
    }

    public String getElementName() {
        return CryptOGAFormat.CA_SERVICE;
    }

    public String getParentElementName() {
        return CryptOGAFormat.CA;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(this.getElementName());
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_NAME, this.getName()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_PROTOCOL, this.getProtocolName()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_HOST, this.getHost()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_PATH, this.getPath()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_PORT, "" + this.getPort()));
        if (this.sender != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_SENDER, this.getSender()));
        }
        if (this.recipient != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_RECIPIENT, this.getRecipient()));
        }
        if (this.auth != null) {
            try {
                String str = this.getBase64Authen();
                parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CA_SVC_AUTHEN, str));
            }
            catch (Exception e) {
                throw new XMLNodeConversionException("PasswordAuthentication ", CryptOGAFormat.CA_SVC_AUTHEN, e.getMessage());
            }
        }
        if (this.params.size() > 0) {
            parent.appendChild(this.params.getXMLNode(doc));
        }
        return parent;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        return this.equals(new AuthorityService(node));
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        ProtocolProperties props = ProtocolProperties.getGeneral();
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("AuthorityService", " Empty node was supplied " + node.toString());
        }
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_NAME)) {
                        this.setService(ServiceName.getInstance(nv));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_PROTOCOL)) {
                        this.setProtocol(ProtocolName.getInstance(nv));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_PORT)) {
                        this.setPort(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_PATH)) {
                        this.setPath(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_HOST)) {
                        this.setHost(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_SENDER)) {
                        this.setSender(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_RECIPIENT)) {
                        this.setRecipient(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_AUTHEN)) {
                        this.setBase64Authen(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CA_SVC_PROTOCOL_PARAMETERS)) {
                        props.setXMLRecord(nodeList.item(i));
                    }
                }
                ++i;
            }
            this.setParameter(props);
        }
        catch (Exception e) {
            throw new XMLRecordDataException("AuthorityService", e.toString());
        }
    }
}

