/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Trusted;

import th.co.oga.security.pki.Transport.HTTPProtocolProperties;
import th.co.oga.security.pki.Transport.HTTPsProtocolProperties;
import th.co.oga.security.pki.Transport.InvalidProtocolNameException;
import th.co.oga.security.pki.Transport.LDAPProtocolProperties;
import th.co.oga.security.pki.Transport.LDAPsProtocolProperties;
import th.co.oga.security.pki.Transport.ProtocolProperties;
import th.co.oga.security.pki.Transport.SMTPProtocolProperties;
import th.co.oga.security.pki.Transport.TransportProtocol;

public class ProtocolName
extends TransportProtocol {
    public static ProtocolName HTTP = new ProtocolName(HTTP_PROTOCOL, 80, false);
    public static ProtocolName LDAP = new ProtocolName(LDAP_PROTOCOL, 378, false);
    public static ProtocolName HTTPS = new ProtocolName(HTTPS_PROTOCOL, 443, true);
    public static ProtocolName LDAPS = new ProtocolName(LDAPS_PROTOCOL, 375, true);
    public static ProtocolName SMTP = new ProtocolName(SMTP_PROTOCOL, 25, false);

    ProtocolName(TransportProtocol tp) {
        this(tp.getName(), tp.getPortNumber(), tp.getSSLStatus());
    }

    public ProtocolName(String name, int port, boolean ssl) {
        super(name, port, ssl);
    }

    public static ProtocolName getInstance(String pname) throws InvalidProtocolNameException {
        return new ProtocolName(TransportProtocol.getProtocol(pname));
    }

    public static ProtocolProperties getProtocolProperties(String protocol) {
        if (protocol.equals(HTTP_PROTOCOL)) {
            return new HTTPProtocolProperties();
        }
        if (protocol.equals(LDAP_PROTOCOL)) {
            return new LDAPProtocolProperties();
        }
        if (protocol.equals(HTTPS_PROTOCOL)) {
            return new HTTPsProtocolProperties();
        }
        if (protocol.equals(LDAPS_PROTOCOL)) {
            return new LDAPsProtocolProperties();
        }
        if (protocol.equals(SMTP_PROTOCOL)) {
            return new SMTPProtocolProperties();
        }
        return ProtocolProperties.getGeneral();
    }
}

