/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Trusted;

import th.co.oga.security.pki.Trusted.InvalidServiceNameException;

public class ServiceName {
    public static ServiceName OCSP = new ServiceName("OCSP", "Online Certificate Status Protocol", "", 0);
    public static ServiceName CRL = new ServiceName("CRL", "Certificate Revokation List", "", 0);
    public static ServiceName FILEUPLOAD = new ServiceName("FUPL", "File upload service", "", 0);
    public static ServiceName CMPCRL = new ServiceName("CMPCRL", "CRL Distribution on Certificate Management Proftocol", "", 0);
    public static ServiceName TIMESTAMP = new ServiceName("Timestamp", "Timestamp", "", 1);
    public static ServiceName CSR = new ServiceName("CSR", "Certification Signing Request", "", 1, "SMTP");
    private String oid;
    private String name;
    private String desc;
    private int fixCA;
    private String supportProtocol;

    protected ServiceName(String name, String description, String oid, int fixCA) {
        this(name, description, oid, fixCA, "HTTP");
    }

    protected ServiceName(String name, String description, String oid, int fixCA, String protocolStuff) {
        this.oid = oid;
        this.name = name;
        this.desc = description;
        this.fixCA = fixCA;
        this.supportProtocol = protocolStuff.toUpperCase();
    }

    public String getOID() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.name;
    }

    public boolean isFix() {
        return this.fixCA == 1;
    }

    public boolean isSupportedProtocol(String protocol) {
        return this.supportProtocol.indexOf(protocol.toUpperCase()) > -1;
    }

    public static ServiceName[] getAllServiceName() {
        return new ServiceName[]{OCSP, CRL, CSR, TIMESTAMP};
    }

    public String[] getSupportProtocols() {
        return this.supportProtocol.split(", ");
    }

    public static ServiceName getInstance(String serviceName) throws InvalidServiceNameException {
        if (serviceName.equalsIgnoreCase("ocsp")) {
            return OCSP;
        }
        if (serviceName.equalsIgnoreCase("crl")) {
            return CRL;
        }
        if (serviceName.equalsIgnoreCase("timestamp")) {
            return TIMESTAMP;
        }
        if (serviceName.equalsIgnoreCase("csr")) {
            return CSR;
        }
        throw new InvalidServiceNameException(String.valueOf(serviceName) + " not found in supported list.");
    }
}

