/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Trusted;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Trusted.TrustedService;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class TrustedPolicies
extends ArrayList
implements XMLRecord {
    private ArrayList idx;
    private int enable;

    public TrustedPolicies() {
        this.idx = new ArrayList();
    }

    public void reset() {
        this.clear();
        this.idx.clear();
    }

    public TrustedPolicies(Node node) throws XMLRecordDataException {
        this.setXMLRecord(node);
    }

    protected void setEnable(String enable) {
        this.enable = new BigDecimal(enable).intValue();
    }

    public void setEnable(boolean status) {
        this.enable = status ? 1 : 0;
    }

    public void setService(TrustedService service) {
        int pointer = this.idx.indexOf(service.getName());
        if (pointer > -1) {
            this.remove(pointer);
            this.add(pointer, service);
        } else {
            this.idx.add(service.getName());
            this.add(service);
        }
    }

    public void setService(ServiceName service, String authority, boolean enable) {
        TrustedService ts = new TrustedService(service);
        ts.setAuthorityName(authority);
        ts.setEnable(enable);
        this.setService(ts);
    }

    public int getNumberOfService() {
        return this.idx.size();
    }

    public TrustedService getService(ServiceName service) {
        int pnt = this.idx.indexOf(service.getName());
        if (pnt > -1) {
            return (TrustedService)this.get(pnt);
        }
        this.setService(new TrustedService(service));
        return new TrustedService(service);
    }

    public TrustedService[] getServices() {
        ServiceName[] sns = ServiceName.getAllServiceName();
        TrustedService[] tss = new TrustedService[sns.length];
        int i = 0;
        while (i < sns.length) {
            tss[i] = this.getService(sns[i]);
            ++i;
        }
        return tss;
    }

    public boolean isEnable() {
        return this.enable == 1;
    }

    public String getElementName() {
        return CryptOGAFormat.TRUSTED;
    }

    public String getParentElementName() {
        return CryptOGAFormat.TRUSTED_PARENT;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(this.getElementName());
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.TRUSTED_POL_ENABLE, "" + (this.isEnable() ? 1 : 0)));
        int i = 0;
        while (i < this.size()) {
            parent.appendChild(((TrustedService)this.get(i)).getXMLNode(doc));
            ++i;
        }
        return parent;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        return true;
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()).getLength() > 0) {
            try {
                int i = 0;
                while (i < nodeList.getLength()) {
                    if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                        String nv = Utils.nodeValue(nodeList.item(i));
                        String nn = Utils.nodeName(nodeList.item(i));
                        if (nn.equalsIgnoreCase(CryptOGAFormat.TRUSTED_POL_ENABLE)) {
                            this.setEnable(nv);
                        } else if (nn.equalsIgnoreCase(CryptOGAFormat.TRUSTED_SVC)) {
                            TrustedService ts = new TrustedService(nodeList.item(i));
                            this.setService(ts);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new XMLRecordDataException("TrustedPolicies", e.toString());
            }
        }
    }
}

