/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Trusted;

import java.math.BigDecimal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class TrustedService
implements XMLRecord {
    private int enable;
    private ServiceName service;
    private String authority = "NA";

    public TrustedService(ServiceName service) {
        this.service = service;
    }

    public TrustedService(Node node) throws XMLRecordDataException {
        this.setXMLRecord(node);
    }

    protected void setService(ServiceName service) {
        this.service = service;
    }

    protected void setEnable(String enable) {
        this.enable = new BigDecimal(enable).intValue();
    }

    public void setAuthorityName(String authority) {
        this.authority = authority;
    }

    public void setEnable(boolean status) {
        this.enable = status ? 1 : 0;
    }

    public String getName() {
        return this.service.getName();
    }

    public String getAuthorityName() {
        return this.authority;
    }

    public String getServiceName() {
        return this.service.getName();
    }

    public boolean isEnable() {
        return this.enable == 1;
    }

    public boolean equals(TrustedService ts) {
        return this.getName().equals(ts.getName());
    }

    public String getElementName() {
        return CryptOGAFormat.TRUSTED_SVC;
    }

    public String getParentElementName() {
        return CryptOGAFormat.TRUSTED;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(this.getElementName());
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.TRUSTED_SVC_NAME, this.getName()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.TRUSTED_CA_NAME, this.getAuthorityName()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.TRUSTED_SVC_ENABLE, "" + (this.isEnable() ? 1 : 0)));
        return parent;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        return this.equals(new TrustedService(node));
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("TrustedService", " Empty node was supplied " + node.toString());
        }
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.TRUSTED_SVC_NAME)) {
                        this.setService(ServiceName.getInstance(nv));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.TRUSTED_SVC_ENABLE)) {
                        this.setEnable(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.TRUSTED_CA_NAME)) {
                        this.setAuthorityName(nv);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new XMLRecordDataException("AuthorityService", e.toString());
        }
    }
}

