/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki;

import com.entegrity.jsdp.security.provider.JSDP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.util.Base64InputStream;
import org.mozilla.jss.util.Base64OutputStream;
import org.w3c.dom.Node;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Reference;
import th.co.oga.security.pki.X500.DName;

public class Utils {
    public static boolean delFile(String pPath, String pFile) {
        boolean rtn = false;
        try {
            File tfile = new File(String.valueOf(pPath) + "//" + pFile);
            rtn = tfile.delete();
        }
        catch (Exception e) {
            rtn = false;
        }
        return rtn;
    }

    public static String getDate() {
        SimpleDateFormat formater = new SimpleDateFormat("MM/dd/yyyy");
        Calendar cal = Calendar.getInstance();
        return formater.format(cal.getTime());
    }

    public static boolean isFileExist(String pPath, String pFile) {
        boolean rtn = false;
        try {
            File tfile = new File(String.valueOf(pPath) + "//" + pFile);
            if (tfile.exists()) {
                rtn = true;
            }
        }
        catch (Exception e) {
            rtn = false;
        }
        return rtn;
    }

    public static String nodeValue(Node pn) {
        String rtn = "";
        try {
            rtn = pn.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            rtn = "";
        }
        return rtn;
    }

    public static String nodeName(Node pn) {
        return pn.getNodeName();
    }

    public static char[] charHash(String str) {
        byte[] seed = str.getBytes();
        char[] pass = new char[seed.length];
        int i = 0;
        while (i < seed.length) {
            pass[seed.length - 1 - i] = (char)(new Byte(seed[i]).hashCode() + 20);
            ++i;
        }
        return pass;
    }

    public static int addJSSProvider() {
        return Security.addProvider((Provider)new JSSProvider());
    }

    public static Provider getJSSProvider() {
        return new JSSProvider();
    }

    public static Provider getWebSentryHSMProvider() {
        return new JSDP();
    }

    public static Provider getSUNProvider() {
        return Security.getProvider("SUN");
    }

    public static Provider getJCEProvider() {
        return Security.getProvider("SunJCE");
    }

    public static Provider getJSSEProvider() {
        return Security.getProvider("SunJSSE");
    }

    public static void listProvider() {
        Provider[] p = Security.getProviders();
        int i = 0;
        while (i < p.length) {
            System.out.println(String.valueOf(p[i].getName()) + " : " + p[i].getInfo() + " Detail :" + p[i].toString());
            ++i;
        }
    }

    public static String getExtension(File file) {
        String ext = null;
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String aMomentIntime() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(1)) + (cal.get(2) > 9 ? "" : "0") + cal.get(2) + (cal.get(5) > 0 ? "" : "0") + cal.get(5) + (cal.get(11) > 0 ? "" : "0") + cal.get(11) + (cal.get(12) > 0 ? "" : "0") + cal.get(12) + (cal.get(13) > 0 ? "" : "0") + cal.get(13) + cal.get(14);
    }

    public static String getWacthTime() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(11)) + ":" + cal.get(12) + ":" + cal.get(13) + "." + cal.get(14);
    }

    public static String trnDate() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(1)) + "-" + (cal.get(2) > 9 ? "" : "0") + cal.get(2) + "-" + (cal.get(5) > 0 ? "" : "0") + cal.get(5) + "-" + (cal.get(11) > 0 ? "" : "0") + cal.get(11) + ":" + (cal.get(12) > 0 ? "" : "0") + cal.get(12);
    }

    public static String getRunnning(SecureRandom sRandom) throws NoSuchAlgorithmException, NoSuchProviderException {
        byte[] runBytes = new byte[8];
        sRandom.nextBytes(runBytes);
        BigInteger runNumber = new BigInteger(1, runBytes);
        return runNumber.toString();
    }

    public static String getBase64FromASN1(ASN1Value val) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64OutputStream b64out = new Base64OutputStream(new PrintStream(out), 16);
        b64out.write(ASN1Util.encode((ASN1Value)val));
        b64out.close();
        String strStream = new String(out.toString());
        out.close();
        return strStream;
    }

    public static String getBase64FromDER(byte[] val) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64OutputStream b64out = new Base64OutputStream(new PrintStream(out), 16);
        b64out.write(val);
        b64out.close();
        String strStream = new String(out.toString());
        out.close();
        return strStream;
    }

    public static byte[] getBytesFromBase64(String val) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(val.getBytes());
        Base64InputStream b64in = new Base64InputStream((InputStream)in);
        byte[] b = new byte[val.getBytes().length];
        b64in.read(b);
        b64in.close();
        in.close();
        return b;
    }

    public static String getCertID(X509Certificate xCert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(xCert.getIssuerX500Principal().getEncoded());
            md.update(xCert.getSerialNumber().toString().getBytes());
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            Base64OutputStream b64 = new Base64OutputStream(new PrintStream(ba));
            b64.write(md.digest());
            b64.flush();
            return ba.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFriendlyName(X509Certificate xCert) {
        try {
            String issuer = DName.getInstance(xCert.getIssuerX500Principal()).getCommonName();
            String owner = DName.getInstance(xCert.getSubjectX500Principal()).getCommonName();
            return String.valueOf(owner) + " - " + issuer;
        }
        catch (ASN1Exception e) {
            return "Invalid Subject ," + e.getMessage();
        }
    }

    public static X509Certificate findLeaf(X509Certificate[] cers) {
        if (cers.length > 1) {
            int i = 0;
            while (i < cers.length) {
                X500Principal issuer = cers[i].getSubjectX500Principal();
                int j = 0;
                while (j < cers.length) {
                    if (!cers[j].getIssuerX500Principal().equals(cers[j].getSubjectX500Principal()) && issuer.equals(cers[j].getIssuerX500Principal())) {
                        return cers[j];
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }
        return cers[0];
    }

    public static X509Certificate findCertOwner(PrivateKey priv, X509Certificate[] cers) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        int pt = 0;
        byte[] testData = Reference.TEST_SIGNATURE.getBytes();
        Signature sig = Signature.getInstance("SHA1With" + priv.getAlgorithm());
        sig.initSign(priv);
        sig.update(testData);
        byte[] sign = sig.sign();
        Signature tester = Signature.getInstance("SHA1With" + priv.getAlgorithm());
        int x = 0;
        while (x < cers.length) {
            tester.initVerify(cers[x].getPublicKey());
            tester.update(testData);
            try {
                if (tester.verify(sign)) {
                    pt = x + 1;
                    break;
                }
            }
            catch (SignatureException signatureException) {
                // empty catch block
            }
            ++x;
        }
        if (pt > 0) {
            return cers[pt - 1];
        }
        return null;
    }

    public static boolean match(Certificate cert, PrivateKey key) {
        if (cert == null || key == null) {
            return false;
        }
        try {
            byte[] data = "some data".getBytes();
            Signature sm = Signature.getInstance("SHA1With" + key.getAlgorithm());
            sm.initSign(key);
            sm.update(data);
            byte[] sig = sm.sign();
            Signature vm = Signature.getInstance("SHA1With" + cert.getPublicKey().getAlgorithm());
            vm.initVerify(cert.getPublicKey());
            vm.update(data);
            return vm.verify(sig);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static PrivateKey getPrivateKey(String algo, byte[] privateKeyStream) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance(algo.toUpperCase());
        PKCS8EncodedKeySpec peks = new PKCS8EncodedKeySpec(privateKeyStream);
        return kf.generatePrivate(peks);
    }

    public static byte[] genTimeSeed() {
        return new String(String.valueOf(Utils.aMomentIntime()) + Utils.aMomentIntime()).getBytes();
    }

    public static void checkNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException(" Null value was supplied  .");
        }
    }

    public static void checkNull(String objName, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(" Null value was supplied to " + objName + ".");
        }
    }
}

