/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.X500;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.DirectoryString;
import org.mozilla.jss.pkix.primitive.Name;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.NameValueInvalidException;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.pki.X500.DNameReference;
import th.co.oga.security.utils.Assert;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class DName
extends Name
implements XMLRecord {
    public static String COMMON_OID = OIDs.commonName;
    public static String COUNTRY_OID = OIDs.countryName;
    public static String LOCALITY_OID = OIDs.localityName;
    public static String STATE_OR_PROVINCE_OID = OIDs.stateOrProvinceName;
    public static String STREET_ADDRESS_OID = OIDs.streetAddress;
    public static String ORGANIZATIONAL_UNIT_OID = OIDs.organizationalUnitName;
    public static String ORGANIZATION_OID = OIDs.organizationName;
    public static String EMAIL_ADDRESS_OID = OIDs.PKCS9_EmailAddress;
    public static OBJECT_IDENTIFIER streetAddressName = DNameReference.STREET_ADDRESS_OID;
    public static OBJECT_IDENTIFIER emailAddressName = DNameReference.EMAIL_ADDRESS_OID;

    public DName() {
    }

    public DName(String cn, String c, String l, String ou, String o, String s) throws CharConversionException {
        this.addCommonName(cn);
        this.addCountryName(c);
        this.addLocalityName(l);
        this.addOrganizationalUnitName(ou);
        this.addOrganizationName(o);
        this.addStateOrProvinceName(s);
    }

    public static DName getInstance(String subjectStr) throws IOException, ASN1Exception {
        X500Principal name = new X500Principal(subjectStr);
        try {
            return new DName((Name)DName.getTemplate().decode((InputStream)new ByteArrayInputStream(name.getEncoded())));
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception((Exception)((Object)e));
        }
    }

    public DName(String cn, String c, String l, String ou, String o, String s, String a, String e) throws NameValueInvalidException {
        try {
            Assert._assert(cn != null && cn.length() > 2, "Incorrect CommonName ");
            this.addCommonName(cn);
            if (c != null && c.length() > 0) {
                this.addCountryName(c);
            }
            if (l != null && l.length() > 0) {
                this.addLocalityName(l);
            }
            if (ou != null && ou.length() > 0) {
                this.addOrganizationalUnitName(ou);
            }
            if (o != null && o.length() > 0) {
                this.addOrganizationName(o);
            }
            if (s != null && s.length() > 0) {
                this.addStateOrProvinceName(s);
            }
            if (a != null && a.length() > 0) {
                this.addStreetAddressName(a);
            }
            if (e != null && e.length() > 0) {
                this.addEmailAddressName(e);
            }
        }
        catch (CharConversionException ce) {
            throw new NameValueInvalidException(" Any ", ce.getMessage());
        }
    }

    public DName(Name name) throws InvalidBERException {
        try {
            int i = 0;
            while (i < name.size()) {
                this.addElement(name.elementAt(i));
                ++i;
            }
        }
        catch (Exception e) {
            throw new InvalidBERException(e.getMessage());
        }
    }

    public static DName getInstance(X500Principal xName) throws ASN1Exception {
        try {
            return new DName((Name)ASN1Util.decode((ASN1Template)DName.getTemplate(), (byte[])xName.getEncoded()));
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public X500Principal getX500Principal() {
        return new X500Principal(ASN1Util.encode((ASN1Value)this));
    }

    public String getCommonName() {
        return this.getValue(commonName);
    }

    public String getCountryName() {
        return this.getValue(countryName);
    }

    public String getStateOrProvinceName() {
        return this.getValue(stateOrProvinceName);
    }

    public String getLocalityName() {
        return this.getValue(localityName);
    }

    public String getOrganizationName() {
        return this.getValue(organizationName);
    }

    public String getOrganizationalUnitName() {
        return this.getValue(organizationalUnitName);
    }

    public String getStreetAddressName() {
        return this.getValue(streetAddressName);
    }

    public String getEMailAddress() {
        return this.getValue(emailAddressName);
    }

    public String[] toArrayOfString() {
        return this.getSubject().split(",");
    }

    public boolean verify() {
        boolean verified = true;
        String cn = this.getValue(DNameReference.COMMON_OID);
        String c = this.getValue(DNameReference.COUNTRY_OID);
        String s = this.getValue(DNameReference.STATE_OR_PROVINCE_OID);
        String l = this.getValue(DNameReference.LOCALITY_OID);
        String o = this.getValue(DNameReference.ORGANIZATION_OID);
        String ou = this.getValue(DNameReference.ORGANIZATIONAL_UNIT_OID);
        String street = this.getValue(DNameReference.STREET_ADDRESS_OID);
        String e = this.getValue(DNameReference.EMAIL_ADDRESS_OID);
        if (cn.length() == 0) {
            verified = false;
        }
        if (c.length() == 0) {
            verified = false;
        }
        if (l.length() == 0) {
            verified = false;
        }
        if (o.length() == 0) {
            verified = false;
        }
        if (ou.length() == 0) {
            verified = false;
        }
        return verified;
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = XMLUtils.nodeValue(nodeList.item(i));
                    if (nv == null) {
                        nv = "";
                    }
                    this.addValue(DNameReference.getOIDFromName(XMLUtils.nodeName(nodeList.item(i))), nv);
                }
                ++i;
            }
        }
        catch (NameValueInvalidException e) {
            throw new XMLRecordDataException("DName", e.toString());
        }
    }

    public void addValue(String oid, String value) throws NameValueInvalidException {
        this.addValue(new OBJECT_IDENTIFIER(oid), value);
    }

    public void addValue(OBJECT_IDENTIFIER oid, String value) throws NameValueInvalidException {
        if (value == null) {
            throw new NameValueInvalidException(DNameReference.getNameFromOID(oid), "null");
        }
        if (value.length() == 0) {
            value = "";
        }
        try {
            if (oid.equals((Object)commonName)) {
                this.addCommonName(value);
            } else if (oid.equals((Object)countryName)) {
                this.addCountryName(value);
            } else if (oid.equals((Object)emailAddressName)) {
                this.addEmailAddressName(value);
            } else if (oid.equals((Object)localityName)) {
                this.addLocalityName(value);
            } else if (oid.equals((Object)organizationalUnitName)) {
                this.addOrganizationalUnitName(value);
            } else if (oid.equals((Object)organizationName)) {
                this.addOrganizationName(value);
            } else if (oid.equals((Object)stateOrProvinceName)) {
                this.addStateOrProvinceName(value);
            } else if (oid.equals((Object)streetAddressName)) {
                this.addStreetAddressName(value);
            }
        }
        catch (Exception e) {
            throw new NameValueInvalidException(DNameReference.getNameFromOID(oid), value);
        }
    }

    public void addStreetAddressName(String st) throws NameValueInvalidException {
        try {
            this.addElement(new AVA(DNameReference.STREET_ADDRESS_OID, (ASN1Value)new PrintableString(st)));
        }
        catch (Exception e) {
            throw new NameValueInvalidException(DNameReference.getNameFromOID(DNameReference.STREET_ADDRESS_OID), st);
        }
    }

    public void addEmailAddressName(String e) throws NameValueInvalidException {
        try {
            this.addElement(new AVA(DNameReference.EMAIL_ADDRESS_OID, (ASN1Value)new DirectoryString(e)));
        }
        catch (Exception ex) {
            throw new NameValueInvalidException(DNameReference.getNameFromOID(DNameReference.EMAIL_ADDRESS_OID), e);
        }
    }

    public Attribute getEmailExtension() throws NameValueInvalidException {
        String eMailStr = this.getValue(DNameReference.EMAIL_ADDRESS_OID);
        Attribute keyExt = null;
        if (eMailStr.length() > 0) {
            try {
                keyExt = new Attribute(DNameReference.EMAIL_ADDRESS_OID, (ASN1Value)new DirectoryString(eMailStr));
            }
            catch (Exception e) {
                throw new NameValueInvalidException("EmailAddress ", eMailStr);
            }
        }
        return keyExt;
    }

    public Attribute getStreetAddressExtension() throws NameValueInvalidException {
        String extStr = this.getValue(DNameReference.STREET_ADDRESS_OID);
        Attribute keyExt = null;
        if (extStr.length() > 0) {
            try {
                keyExt = new Attribute(DNameReference.EMAIL_ADDRESS_OID, (ASN1Value)new PrintableString(extStr));
            }
            catch (Exception e) {
                throw new NameValueInvalidException("EmailAddress ", extStr);
            }
        }
        return keyExt;
    }

    public String getValue(String oid) {
        return this.getValue(new OBJECT_IDENTIFIER(oid));
    }

    public String getValue(OBJECT_IDENTIFIER oid) {
        String rtn = "";
        try {
            int i = 0;
            while (i < this.size()) {
                ANY any = this.elementAt(i).at(0).getValue();
                if (oid.equals((Object)this.elementAt(i).at(0).getOID())) {
                    rtn = new String(any.getContents());
                    break;
                }
                ++i;
            }
        }
        catch (InvalidBERException e) {
            throw new IllegalArgumentException("Error while get value of subject OID " + oid.toString());
        }
        try {
            rtn = new DirectoryString(rtn).toString();
        }
        catch (Exception e) {
            rtn = "";
        }
        return rtn;
    }

    public String getFriendlyName() {
        String cn = "";
        String o = "";
        try {
            int i = 0;
            while (i < this.size()) {
                ANY any;
                if (DNameReference.COMMON_OID.equals((Object)this.elementAt(i).at(0).getOID())) {
                    any = this.elementAt(i).at(0).getValue();
                    cn = new String(any.getContents());
                }
                if (DNameReference.ORGANIZATION_OID.equals((Object)this.elementAt(i).at(0).getOID())) {
                    any = this.elementAt(i).at(0).getValue();
                    o = new String(any.getContents());
                }
                ++i;
            }
        }
        catch (InvalidBERException invalidBERException) {
            // empty catch block
        }
        return String.valueOf(cn) + " - " + o;
    }

    public String getSubject() {
        String sname = "";
        sname = this.addAVAString(sname, "CN", this.getValue(DNameReference.COMMON_OID));
        sname = this.addAVAString(sname, "C", this.getValue(DNameReference.COUNTRY_OID));
        sname = this.addAVAString(sname, "L", this.getValue(DNameReference.LOCALITY_OID));
        sname = this.addAVAString(sname, "O", this.getValue(DNameReference.ORGANIZATION_OID));
        sname = this.addAVAString(sname, "OU", this.getValue(DNameReference.ORGANIZATIONAL_UNIT_OID));
        sname = this.addAVAString(sname, "E", this.getValue(DNameReference.EMAIL_ADDRESS_OID));
        sname = this.addAVAString(sname, "S", this.getValue(DNameReference.STATE_OR_PROVINCE_OID));
        sname = this.addAVAString(sname, "Street", this.getValue(DNameReference.STREET_ADDRESS_OID));
        return sname;
    }

    public String addAVAString(String data, String key, String value) {
        if (value.length() > 0 && !value.equals(" ")) {
            data = String.valueOf(data) + (value.length() > 0 ? String.valueOf(data.length() > 0 ? ", " : "") + key + "=" + value : "");
        }
        return data;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        return this.getXMLNode(doc, CryptOGAFormat.PROFILE_DNAME);
    }

    public Node getXMLNode(Document doc, String implicitName) throws XMLNodeConversionException {
        Element node = doc.createElement(implicitName);
        try {
            int i = 0;
            while (i < this.size()) {
                ANY any = this.elementAt(i).at(0).getValue();
                OBJECT_IDENTIFIER oid = this.elementAt(i).at(0).getOID();
                Element child = doc.createElement(DNameReference.getNameFromOID(oid));
                child.appendChild(doc.createTextNode(new String(any.getContents())));
                node.appendChild(child);
                ++i;
            }
        }
        catch (InvalidBERException e) {
            throw new XMLNodeConversionException(this.toString(), CryptOGAFormat.PROFILE_DNAME, e.toString());
        }
        return node;
    }

    public String getElementName() {
        return CryptOGAFormat.PROFILE_DNAME;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        DName dname = new DName();
        dname.setXMLRecord(node);
        return this.hashCode() == dname.hashCode();
    }

    public String getParentElementName() {
        return CryptOGAFormat.PROFILE;
    }

    public static String getFriendlyName(X509Certificate xCert) {
        return Utils.getFriendlyName(xCert);
    }

    public boolean equals(DName compName) {
        return this.getX500Principal().equals(compName.getX500Principal());
    }

    public String toString() {
        try {
            StringWriter buff = new StringWriter();
            int i = 0;
            while (i < this.size()) {
                ANY any = this.elementAt(i).at(0).getValue();
                buff.write(this.elementAt(i).at(0).getOID().toString());
                buff.write(String.valueOf(new String(any.getContents())) + "\n");
                ++i;
            }
            return buff.toString();
        }
        catch (Exception e) {
            return "Error:" + e.toString();
        }
    }
}

