/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.X500;

import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import th.co.oga.security.pki.OIDs;

public class DNameReference {
    public static String COMMON_OID_STR = OIDs.commonName;
    public static String COUNTRY_OID_STR = OIDs.countryName;
    public static String LOCALITY_OID_STR = OIDs.localityName;
    public static String STATE_OR_PROVINCE_OID_STR = OIDs.stateOrProvinceName;
    public static String STREET_ADDRESS_OID_STR = OIDs.streetAddress;
    public static String ORGANIZATIONAL_UNIT_OID_STR = OIDs.organizationalUnitName;
    public static String ORGANIZATION_OID_STR = OIDs.organizationName;
    public static String EMAIL_ADDRESS_OID_STR = OIDs.PKCS9_EmailAddress;
    public static OBJECT_IDENTIFIER COMMON_OID = new OBJECT_IDENTIFIER(COMMON_OID_STR);
    public static OBJECT_IDENTIFIER COUNTRY_OID = new OBJECT_IDENTIFIER(COUNTRY_OID_STR);
    public static OBJECT_IDENTIFIER LOCALITY_OID = new OBJECT_IDENTIFIER(LOCALITY_OID_STR);
    public static OBJECT_IDENTIFIER STATE_OR_PROVINCE_OID = new OBJECT_IDENTIFIER(OIDs.stateOrProvinceName);
    public static OBJECT_IDENTIFIER STREET_ADDRESS_OID = new OBJECT_IDENTIFIER(STREET_ADDRESS_OID_STR);
    public static OBJECT_IDENTIFIER ORGANIZATIONAL_UNIT_OID = new OBJECT_IDENTIFIER(ORGANIZATIONAL_UNIT_OID_STR);
    public static OBJECT_IDENTIFIER ORGANIZATION_OID = new OBJECT_IDENTIFIER(ORGANIZATION_OID_STR);
    public static OBJECT_IDENTIFIER EMAIL_ADDRESS_OID = new OBJECT_IDENTIFIER(EMAIL_ADDRESS_OID_STR);
    public static String COMMON_ABBR = "CN";
    public static String LOCALITY_ABBR = "L";
    public static String STATE_OR_PROVINCE_ABBR = "ST";
    public static String ORGANIZATION_ABBR = "O";
    public static String ORGANIZATIONAL_UNIT_ABBR = "OU";
    public static String COUNTRY_ABBR = "C";
    public static String STREET_ADDRESS_ABBR = "STREET";
    public static String EMAIL_ADDRESS_ABBR = "E";
    public static String COMMON_STRING_NAME = "CommonName";
    public static String COUNTRY_STRING_NAME = "CountryName";
    public static String LOCALITY_STRING_NAME = "LocalityName";
    public static String STATE_OR_PROVINCE_STRING_NAME = "StateOrProvinceName";
    public static String STREET_ADDRESS_STRING_NAME = "StreetAddressName";
    public static String ORGANIZATIONAL_UNIT_STRING_NAME = "OrganizationalUnitName";
    public static String ORGANIZATION_STRING_NAME = "OrganizationName";
    public static String EMAIL_ADDRESS_STRING_NAME = "EmailAddressName";

    public static String getOIDString(OBJECT_IDENTIFIER oid) {
        return OIDs.fromLongs(oid.getNumbers());
    }

    public static String getDNKey(String oid) {
        String name = oid;
        if (oid.equals(COMMON_OID)) {
            name = COMMON_ABBR;
        } else if (oid.equals(COUNTRY_OID)) {
            name = COUNTRY_ABBR;
        } else if (oid.equals(EMAIL_ADDRESS_OID)) {
            name = EMAIL_ADDRESS_ABBR;
        } else if (oid.equals(LOCALITY_OID)) {
            name = LOCALITY_ABBR;
        } else if (oid.equals(ORGANIZATION_OID)) {
            name = ORGANIZATION_ABBR;
        } else if (oid.equals(ORGANIZATIONAL_UNIT_OID)) {
            name = ORGANIZATIONAL_UNIT_ABBR;
        } else if (oid.equals(STATE_OR_PROVINCE_OID)) {
            name = STATE_OR_PROVINCE_ABBR;
        } else if (oid.equals(STREET_ADDRESS_OID)) {
            name = STREET_ADDRESS_ABBR;
        }
        return name;
    }

    public static String getNameFromOID(OBJECT_IDENTIFIER oid) {
        String name = oid.toString();
        if (oid.equals((Object)COMMON_OID)) {
            name = COMMON_STRING_NAME;
        } else if (oid.equals((Object)COUNTRY_OID)) {
            name = COUNTRY_STRING_NAME;
        } else if (oid.equals((Object)EMAIL_ADDRESS_OID)) {
            name = EMAIL_ADDRESS_STRING_NAME;
        } else if (oid.equals((Object)LOCALITY_OID)) {
            name = LOCALITY_STRING_NAME;
        } else if (oid.equals((Object)ORGANIZATION_OID)) {
            name = ORGANIZATION_STRING_NAME;
        } else if (oid.equals((Object)ORGANIZATIONAL_UNIT_OID)) {
            name = ORGANIZATIONAL_UNIT_STRING_NAME;
        } else if (oid.equals((Object)STATE_OR_PROVINCE_OID)) {
            name = STATE_OR_PROVINCE_STRING_NAME;
        } else if (oid.equals((Object)STREET_ADDRESS_OID)) {
            name = STREET_ADDRESS_STRING_NAME;
        }
        return name;
    }

    public static OBJECT_IDENTIFIER getOIDFromName(String oidStr) {
        OBJECT_IDENTIFIER oid = oidStr.equalsIgnoreCase(COMMON_STRING_NAME) ? COMMON_OID : (oidStr.equalsIgnoreCase(COUNTRY_STRING_NAME) ? COUNTRY_OID : (oidStr.equalsIgnoreCase(EMAIL_ADDRESS_STRING_NAME) ? EMAIL_ADDRESS_OID : (oidStr.equalsIgnoreCase(LOCALITY_STRING_NAME) ? LOCALITY_OID : (oidStr.equalsIgnoreCase(ORGANIZATION_STRING_NAME) ? ORGANIZATION_OID : (oidStr.equalsIgnoreCase(ORGANIZATIONAL_UNIT_STRING_NAME) ? ORGANIZATIONAL_UNIT_OID : (oidStr.equalsIgnoreCase(STATE_OR_PROVINCE_STRING_NAME) ? STATE_OR_PROVINCE_OID : STREET_ADDRESS_OID))))));
        return oid;
    }
}

