/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.XML;

import com.sun.org.apache.xml.internal.security.Init;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLData {
    private Document doc;
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private Transformer transformer;

    public XMLData() {
        if (!Init.isInitialized()) {
            Init.init();
        }
        try {
            this.dbf.setNamespaceAware(true);
            TransformerFactory tf = TransformerFactory.newInstance();
            this.transformer = tf.newTransformer();
        }
        catch (Exception e) {
            throw new NullPointerException("Cannot initialize XML Security System ");
        }
    }

    public XMLData(Document doc) {
        this();
        this.doc = doc;
    }

    public XMLData(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        this();
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        this.doc = db.parse(in);
        in.close();
    }

    public XMLData(byte[] data) throws ParserConfigurationException, IOException, SAXException {
        this(new ByteArrayInputStream(data));
    }

    public XMLData(String fileName) throws ParserConfigurationException, IOException, SAXException {
        this(new FileInputStream(fileName));
    }

    public Document getDocument() {
        return this.doc;
    }

    public void getEncode(OutputStream out) {
        try {
            this.transformer.transform(new DOMSource(this.doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public byte[] getEncode() {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        this.getEncode(buff);
        return buff.toByteArray();
    }
}

