/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.XML;

import com.sun.org.apache.xml.internal.security.Init;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import th.co.oga.security.pki.Packaging.RawEncryptedInfo;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;

public class XMLEnvelopedData
extends RawEnvelopedData {
    private Document doc;
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private Transformer transformer;

    public XMLEnvelopedData() {
        if (!Init.isInitialized()) {
            Init.init();
        }
        try {
            this.dbf.setNamespaceAware(true);
            TransformerFactory tf = TransformerFactory.newInstance();
            this.transformer = tf.newTransformer();
        }
        catch (Exception e) {
            throw new NullPointerException("Cannot initialize XML Security System ");
        }
    }

    public XMLEnvelopedData(Document doc) {
        this.doc = doc;
    }

    public XMLEnvelopedData(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        this();
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        this.doc = db.parse(in);
        in.close();
    }

    public XMLEnvelopedData(byte[] data) throws ParserConfigurationException, IOException, SAXException {
        this(new ByteArrayInputStream(data));
    }

    public XMLEnvelopedData(String fileName) throws ParserConfigurationException, IOException, SAXException {
        this(new FileInputStream(fileName));
    }

    public Document getDocument() {
        return this.doc;
    }

    public void getEncode(OutputStream out) {
        try {
            this.transformer.transform(new DOMSource(this.doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public byte[] getEncode() {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        this.getEncode(buff);
        return buff.toByteArray();
    }

    XMLEnvelopedData(RawEncryptedInfo encryptedData) {
    }

    public Iterator getRecipients() {
        return null;
    }
}

