/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.XML;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedData;
import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.KeyGenerateFailException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.SecurePackageCRLException;
import th.co.oga.security.pki.Packaging.SecurePackageEncipherException;
import th.co.oga.security.pki.Packaging.SecurePackageEncodingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageEnvelopeException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackageOpenEnvelopeException;
import th.co.oga.security.pki.Packaging.SecurePackageSigningFailException;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;
import th.co.oga.security.pki.Packaging.SecurePackager;
import th.co.oga.security.pki.Packaging.X509KeySelector;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.pki.XML.XMLData;
import th.co.oga.security.pki.XML.XMLEnvelopedData;
import th.co.oga.security.pki.XML.XMLSecureReference;
import th.co.oga.security.pki.XML.XMLSignedData;
import th.co.oga.security.pki.XML.XMLSigningTime;

public class XMLSecurePackager
extends SecurePackager
implements XMLSecureReference {
    public static String XPATH2_FILTER_STRING = "here()/ancestor::dsig:Signature";
    public static String XPATH_FILTER_STRING = "not(ancestor-or-self::dsig:Signature)";
    private XMLSignatureFactory xMLSignatureFactory;
    private String packagerName = "XMLSecurePackager";
    private X509KeySelector keySelector = new X509KeySelector();

    public XMLSecurePackager(Room room) throws AlgorithmSupportException, EntryNotFoundException, SecureStoreException {
        super(room.getSecureOperator());
        this.applyPolicy(room);
        try {
            String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
            Provider jsr105Provider = (Provider)Class.forName(providerName).newInstance();
            Security.addProvider(jsr105Provider);
            this.xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", jsr105Provider);
            if (!Init.isInitialized()) {
                Init.init();
            }
        }
        catch (Exception e) {
            throw new SecureStoreException("Can not initial XMLSecurePackager, " + e.toString());
        }
    }

    public AlgorithmProfile getEncryptionAlgorithm(String algoName) throws AlgorithmSupportException {
        String algo = algoName;
        if (algoName.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            algo = "DESede";
        }
        if (algoName.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            algo = "DESede";
        }
        return super.getEncryptionAlgorithm(algo);
    }

    public byte[] decodeData(byte[] data) {
        return data;
    }

    public byte[] encodeData(byte[] data) {
        return data;
    }

    public void exportSignedData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(this.getData(signedData));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Output stream is not work");
        }
    }

    public byte[] exportSignedData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        return this.getData(signedData);
    }

    public void getData(byte[] contentInfo, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(contentInfo);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Output stream is not work");
        }
    }

    public byte[] getData(byte[] contentInfo) throws SecurePackageInvalidDataException {
        return contentInfo;
    }

    public void getData(RawSignedData signedData, OutputStream out) throws SecurePackageInvalidDataException {
        try {
            out.write(this.getData(signedData));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Output stream is not work");
        }
    }

    public byte[] getData(RawSignedData signedData) throws SecurePackageInvalidDataException {
        return signedData.getData();
    }

    public RawSignedData importSignedData(byte[] bytes) throws SecurePackageEncodingFailException {
        try {
            return this.importSignedData(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            throw new SecurePackageEncodingFailException("XMLSecurePackager", e);
        }
    }

    public RawSignedData importSignedData(InputStream in) throws SecurePackageEncodingFailException {
        try {
            return new XMLSignedData(in);
        }
        catch (Exception e) {
            throw new SecurePackageEncodingFailException("XMLSecurePackager", e);
        }
    }

    public RawSignedData signData(byte[] data) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        try {
            XMLSignedData signedData = new XMLSignedData(new XMLData(data));
            this.sign(signedData);
            return signedData;
        }
        catch (SAXException e) {
            throw new SecurePackageSigningFailException(this.packagerName, "Error while read XML data, XML Data may not well form please check xml data,  " + e.toString());
        }
        catch (ParserConfigurationException e) {
            throw new SecurePackageSigningFailException(this.packagerName, "Error while read XML data, " + e.toString());
        }
        catch (IOException e) {
            throw new SecurePackageSigningFailException(this.packagerName, "I/O Error while read XML data, " + e.toString());
        }
    }

    public void sign(RawSignedData signedData, CertProfile signerCert) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        block14: {
            if (signedData instanceof XMLSignedData) {
                try {
                    if (signerCert == null) {
                        try {
                            signerCert = this.getDefaultCertificate();
                        }
                        catch (SecureStoreException e) {
                            throw new SecurePackageSigningFailException("XMLSecurePackager", "Can't get signer's certificate," + e.getMessage());
                        }
                    }
                    boolean reqPrefix = false;
                    XMLSignedData xSignedData = (XMLSignedData)signedData;
                    AlgorithmProfile sgnAlg = this.cTaker.getSigningAlgo();
                    AlgorithmProfile digestAlgo = this.macAlgoSet.findByName(sgnAlg.getMessageDigestAlgorithmName());
                    String digestAlgoName = "http://www.w3.org/2000/09/xmldsig#sha1";
                    DigestMethod digestMethod = this.xMLSignatureFactory.newDigestMethod(digestAlgoName, null);
                    NodeList nl = xSignedData.getDocument().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
                    String signID = "" + (nl.getLength() + 1);
                    String signatureID = "DSIG" + signID;
                    Transform envTransformer = this.xMLSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("dsig", "http://www.w3.org/2000/09/xmldsig#");
                    XPathFilterParameterSpec xp1param = null;
                    XPathType xp2param1 = null;
                    if (reqPrefix) {
                        xp2param1 = new XPathType(XPATH2_FILTER_STRING, XPathType.Filter.SUBTRACT);
                        xp1param = new XPathFilterParameterSpec(XPATH_FILTER_STRING);
                    } else {
                        xp2param1 = new XPathType(XPATH2_FILTER_STRING, XPathType.Filter.SUBTRACT, map);
                        xp1param = new XPathFilterParameterSpec(XPATH_FILTER_STRING, map);
                    }
                    Transform xp1Transformer = this.xMLSignatureFactory.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xp1param);
                    ArrayList<XPathType> xp2pList = new ArrayList<XPathType>();
                    xp2pList.add(xp2param1);
                    XPathFilter2ParameterSpec xp2params = new XPathFilter2ParameterSpec(xp2pList);
                    Transform xp2Transformer = this.xMLSignatureFactory.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", xp2params);
                    ArrayList<Transform> tmsList = new ArrayList<Transform>();
                    tmsList.add(envTransformer);
                    Document doc = xSignedData.getDocument();
                    String timeStampID = "TIMESTAMP" + signID;
                    List<XMLSigningTime> timeStamp = Collections.singletonList(XMLSigningTime.getInstance(Calendar.getInstance(), reqPrefix));
                    SignatureProperty timeStampProperty = this.xMLSignatureFactory.newSignatureProperty(timeStamp, "#" + signatureID, timeStampID);
                    Reference timeStampRef = this.xMLSignatureFactory.newReference("#" + timeStampID, digestMethod, null, "http://www.w3.org/2000/09/xmldsig#SignatureProperties", null);
                    SignatureProperties signProperties = this.xMLSignatureFactory.newSignatureProperties(Collections.singletonList(timeStampProperty), null);
                    XMLObject dataObj = this.xMLSignatureFactory.newXMLObject(Collections.singletonList(signProperties), null, null, null);
                    Reference dataRef = this.xMLSignatureFactory.newReference("", digestMethod, tmsList, null, null);
                    ArrayList<Reference> tbsRef = new ArrayList<Reference>();
                    tbsRef.add(dataRef);
                    tbsRef.add(timeStampRef);
                    CanonicalizationMethod canonicalizeMethod = this.xMLSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
                    SignatureMethod signatureMethod = this.xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
                    SignedInfo signedInfo = this.xMLSignatureFactory.newSignedInfo(canonicalizeMethod, signatureMethod, tbsRef);
                    KeyInfoFactory kif = this.xMLSignatureFactory.getKeyInfoFactory();
                    X509Data x509Data = kif.newX509Data(Collections.singletonList(signerCert.getX509Cert()));
                    javax.xml.crypto.dsig.keyinfo.KeyInfo keyInfo = kif.newKeyInfo(Collections.singletonList(x509Data));
                    XMLSignature signature = this.xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(dataObj), signatureID, null);
                    DOMSignContext signer = new DOMSignContext(this.sOper.getJCAPrivateKey(signerCert), (Node)doc.getDocumentElement());
                    if (reqPrefix) {
                        signer.setDefaultNamespacePrefix("dsig");
                    }
                    try {
                        signature.sign(signer);
                        break block14;
                    }
                    catch (Exception ee) {
                        throw new SecurePackageSigningFailException("XMLSecurePackager", "Signature signing fail," + ee.getMessage());
                    }
                }
                catch (SecureStoreException e) {
                    throw new SecurePackageSigningFailException("XMLSecurePackager", "DOM Signer initial fail," + e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new SecurePackageSigningFailException("XMLSecurePackager", "Timestamp create fail," + e.getMessage());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SecurePackageSigningFailException("XMLSecurePackager", "Algorithm support error," + e.getMessage());
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new SecurePackageSigningFailException("XMLSecurePackager", "Algorithm initialization fail," + e.getMessage());
                }
            }
            throw new SecurePackageSigningFailException("XMLSecurePackager", "Supplied SignedData is not XML data");
        }
    }

    public void sign(RawSignedData signedData) throws AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageSigningFailException {
        this.sign(signedData, null);
    }

    public void signatureVerify(RawSignedData signedData, CertProfile cert) throws SecurePackageVerifyFailException, SignatureException {
        if (!(signedData instanceof XMLSignedData)) {
            throw new SecurePackageVerifyFailException(this.packagerName, "Supplied SignedData is not XML data format");
        }
        XMLSignedData xSignedData = (XMLSignedData)signedData;
        Document doc = xSignedData.getDocument();
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new SecurePackageVerifyFailException(this.packagerName, "There are no any XML signature in data.");
        }
        int doSgns = 0;
        int igSgns = 0;
        int inSgns = 0;
        StringWriter sw = new StringWriter();
        this.traceInfo("XML Secure Packager start to validate " + nl.getLength() + " signature");
        int n = 0;
        while (n < nl.getLength()) {
            block24: {
                boolean doo = false;
                try {
                    DOMValidateContext vContext = new DOMValidateContext(this.keySelector, nl.item(n));
                    XMLSignature signature = this.xMLSignatureFactory.unmarshalXMLSignature(vContext);
                    X509Certificate xCert = this.keySelector.getSignerCertificate(signature.getKeyInfo(), vContext);
                    if (cert == null) {
                        doo = true;
                    } else if (cert.isSubject(xCert.getSubjectX500Principal())) {
                        doo = true;
                    }
                    if (!doo) break block24;
                    this.traceInfo(" ===> Signature of " + xCert.getSubjectDN().toString());
                    if (signature.validate(vContext)) {
                        Calendar signCal = Calendar.getInstance();
                        try {
                            Node signingTimeNode = XMLSigningTime.getTimeStampeNode(nl.item(n));
                            if (signingTimeNode != null) {
                                XMLSigningTime signingTime = new XMLSigningTime(signingTimeNode);
                                Date d = XMLSigningTime.DATE_FORMAT.parse(signingTime.getTime());
                                signCal.setTime(d);
                            }
                        }
                        catch (ParseException e) {
                            this.traceInfo("\t Warning signing time can not parsed ,use system time for validatation.");
                        }
                        try {
                            this.certificateVerify(xCert, signCal);
                        }
                        catch (Exception e) {
                            throw new SecurePackageVerifyFailException(this.packagerName, "Error while verify signer's certificate, " + e.toString());
                        }
                        ++doSgns;
                        break block24;
                    }
                    ++inSgns;
                    String sgnID = "" + n;
                    if (signature.getId() != null) {
                        sgnID = signature.getId();
                    }
                    sw.write("\nSignature#" + sgnID + " verification result: \n Signer's name:" + Utils.getFriendlyName(xCert));
                    System.out.println("\t Verify Sub Signature-->" + Utils.getWacthTime());
                    if (signature.getSignatureValue().validate(vContext)) {
                        sw.write("\n\t Signature value is validate ");
                        Iterator<Reference> itr = signature.getSignedInfo().getReferences().iterator();
                        int r = 0;
                        System.out.println("\t Verify Document Alter-->" + Utils.getWacthTime());
                        while (itr.hasNext()) {
                            Reference tRef = itr.next();
                            if (tRef.validate(vContext)) {
                                sw.write("\n\t Reference data#" + r + " " + tRef.getURI() + " is validate ");
                            } else {
                                sw.write("\n\t Reference data#" + r + " " + tRef.getURI() + " is not validate ");
                            }
                            ++r;
                        }
                    } else {
                        sw.write("\n Signature value not validate ");
                    }
                    this.traceInfo(sw.toString());
                }
                catch (KeySelectorException e) {
                    ++igSgns;
                }
                catch (MarshalException e) {
                    throw new SecurePackageVerifyFailException(this.packagerName, " Error while verify signature value, " + e.getMessage());
                }
                catch (XMLSignatureException e) {
                    throw new SecurePackageVerifyFailException(this.packagerName, " Error while verify signature value, " + e.getMessage());
                }
            }
            this.traceInfo("XML Secure Packager finished validatation ");
            ++n;
        }
        if (doSgns == 0) {
            throw new SecurePackageVerifyFailException(this.packagerName, "There are no any validate signature, ignore bad signature " + igSgns + ", invalidate " + inSgns + "\n" + sw.toString());
        }
        if (inSgns + igSgns > 0) {
            throw new SecurePackageVerifyFailException(this.packagerName, "There are any signature is not validate, ignore bad " + igSgns + " signature, an invalidate " + inSgns + " signature\n" + sw.toString());
        }
    }

    public void signerVerify(RawSignedData signedData, CertProfile cert) throws SecurePackageVerifyFailException, SecurePackageCRLException, SignatureException {
        this.signatureVerify(signedData, cert);
    }

    public RawEnvelopedData envelopeData(byte[] data, CertProfile recipient) throws SecurePackageEnvelopeException, SecurePackageEncipherException {
        EncryptedKey encryptedKey;
        XMLCipher keyCipher;
        XMLEnvelopedData envelopedData;
        SecretKey encryptionKey;
        this.traceInfo("XML Secure Packager Start to envelope data to " + recipient.getX509Cert().getSubjectDN().getName());
        String encAlgoUri = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        try {
            AlgorithmProfile encAlgo = this.sOper.getSupportAlgorithm().getEncryptionAlgorithm().findByName("DESede");
            encryptionKey = this.cOper.genSecretKey(encAlgo, null);
        }
        catch (KeyGenerateFailException e) {
            throw new SecurePackageEncipherException(this.packagerName, "Error while generate data encryption key , " + e.getMessage());
        }
        catch (AlgorithmSupportException e) {
            throw new SecurePackageEncipherException(this.packagerName, "Error while generate data encryption key , " + e.getMessage());
        }
        try {
            envelopedData = new XMLEnvelopedData(data);
        }
        catch (Exception e) {
            throw new SecurePackageEncipherException(this.packagerName, "Error while read xml data, " + e.toString());
        }
        PublicKey recpKey = recipient.getPublicKey();
        String algorithmName = recpKey.getAlgorithm();
        String wrapKeyAlgoUri = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        Document doc = envelopedData.getDocument();
        try {
            keyCipher = XMLCipher.getInstance((String)wrapKeyAlgoUri);
        }
        catch (XMLEncryptionException e) {
            throw new SecurePackageEncipherException(this.packagerName, "Error while load Cipher, " + e.getMessage());
        }
        try {
            keyCipher.init(3, (Key)recpKey);
        }
        catch (Exception e) {
            throw new SecurePackageEncipherException(this.packagerName, "Error while initial key wrapper, " + e.getMessage());
        }
        try {
            encryptedKey = keyCipher.encryptKey(doc, (Key)encryptionKey);
        }
        catch (XMLEncryptionException e) {
            e.printStackTrace();
            throw new SecurePackageEncipherException(this.packagerName, "Error while key wrapping, " + e.getMessage());
        }
        this.traceInfo("Create XML Key info for data encrypted key");
        KeyInfo keyInfo = new KeyInfo(doc);
        try {
            keyInfo.add(encryptedKey);
        }
        catch (XMLSecurityException e) {
            throw new SecurePackageEncipherException(this.packagerName, "Error while create recipient's X509 Key Info, " + e.getMessage());
        }
        try {
            XMLCipher xmlCipher = XMLCipher.getInstance((String)encAlgoUri);
            xmlCipher.init(1, (Key)encryptionKey);
            EncryptedData encryptedData = xmlCipher.getEncryptedData();
            encryptedData.setKeyInfo(keyInfo);
            xmlCipher.doFinal(doc, doc.getDocumentElement(), true);
        }
        catch (Exception e) {
            throw new SecurePackageEncipherException(this.packagerName, "Error while data encipherment operation, " + e.getMessage());
        }
        return envelopedData;
    }

    public RawEnvelopedData envelopeData(byte[] data) throws SecurePackageEnvelopeException, SecurePackageEncipherException {
        try {
            return this.envelopeData(data, this.getDefaultCertificate());
        }
        catch (SecureStoreException e) {
            throw new SecurePackageEnvelopeException(this.packagerName, "Error while get default certificate," + e.getMessage());
        }
    }

    public byte[] openEnvelopedData(RawEnvelopedData enveloped) throws SecurePackageOpenEnvelopeException, SecurePackageEncipherException, ASN1Exception {
        if (!(enveloped instanceof XMLEnvelopedData)) {
            throw new SecurePackageEncipherException(this.packagerName, "Supplied data is not XML Digital Encrypoted format ");
        }
        this.traceInfo("XML Secure Packager Start to open enveloped data ");
        CertProfile defaultCertificate = null;
        try {
            defaultCertificate = this.getDefaultCertificate();
        }
        catch (SecureStoreException e) {
            throw new SecurePackageEncipherException(this.packagerName, "System error while get default certificate, " + e.getMessage());
        }
        XMLEnvelopedData envelopedData = (XMLEnvelopedData)enveloped;
        Document doc = envelopedData.getDocument();
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        if (nl.getLength() > 0) {
            try {
                Document data = null;
                XMLCipher xmlCipher = XMLCipher.getInstance();
                xmlCipher.init(2, null);
                xmlCipher.setKEK((Key)this.sOper.getJCAPrivateKey(defaultCertificate));
                while (nl.getLength() > 0) {
                    Element encryptedDataElement = (Element)nl.item(0);
                    try {
                        data = xmlCipher.doFinal(doc, encryptedDataElement);
                    }
                    catch (Exception e) {
                        throw new SecurePackageEncipherException(this.packagerName, "Private key can not open enveloped XML data, " + e.toString());
                    }
                    nl = data.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
                }
                XMLData xData = new XMLData(data);
                return xData.getEncode();
            }
            catch (SecureStoreFindingFailException e) {
                throw new SecurePackageEncipherException(this.packagerName, "System error while find private key from store, " + e.getMessage());
            }
            catch (SecureStoreException e) {
                throw new SecurePackageEncipherException(this.packagerName, "System error while find private key from store, " + e.getMessage());
            }
            catch (XMLEncryptionException e) {
                throw new SecurePackageEncipherException(this.packagerName, "Error occured while initial XML Cipher, " + e.getMessage());
            }
        }
        return envelopedData.getEncode();
    }

    public RawEnvelopedData importEnvelopedData(byte[] envelopedData) throws SecurePackageEncodingFailException {
        try {
            return new XMLEnvelopedData(envelopedData);
        }
        catch (Exception e) {
            throw new SecurePackageEncodingFailException(this.packagerName, "Error while read input data, " + e.toString());
        }
    }

    public RawEnvelopedData importEnvelopedData(InputStream in) throws SecurePackageEncodingFailException {
        try {
            return new XMLEnvelopedData(in);
        }
        catch (Exception e) {
            throw new SecurePackageEncodingFailException(this.packagerName, "Error while read input data, " + e.toString());
        }
    }

    public void exportEnvelopedData(RawEnvelopedData envelopedData, OutputStream out) throws SecurePackageInvalidDataException {
        if (!(envelopedData instanceof XMLEnvelopedData)) {
            throw new SecurePackageInvalidDataException(this.packagerName, "Supplied data is not XML Digital Encrypoted format ");
        }
        ((XMLEnvelopedData)envelopedData).getEncode(out);
    }

    public byte[] exportEnvelopedData(RawEnvelopedData envelopedData) throws SecurePackageInvalidDataException {
        if (envelopedData instanceof XMLEnvelopedData) {
            return ((XMLEnvelopedData)envelopedData).getEncode();
        }
        throw new SecurePackageInvalidDataException(this.packagerName, "Supplied data is not XML Digital Encrypoted format ");
    }

    public void addRecipient(RawEnvelopedData envData, CertProfile cert) throws SecurePackageEnvelopeException {
        throw new SecurePackageEnvelopeException(this.packagerName, "Do not support this operation for XML Digital Encryption");
    }
}

