/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.XML;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Packaging.RawContentInfo;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;
import th.co.oga.security.pki.Packaging.X509KeySelector;
import th.co.oga.security.pki.XML.XMLData;
import th.co.oga.security.pki.XML.XMLSecureReference;
import th.co.oga.security.pki.XML.XMLSignerInfo;
import th.co.oga.security.pki.XML.XMLSigningTime;

public class XMLSignedData
extends RawSignedData
implements XMLSecureReference {
    private Document doc;
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private XMLSignatureFactory xMLSignatureFactory;
    private Transformer transformer;

    public XMLSignedData() {
        this.dbf.setNamespaceAware(true);
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        try {
            Provider jsr105Provider = (Provider)Class.forName(providerName).newInstance();
            this.xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", jsr105Provider);
            TransformerFactory tf = TransformerFactory.newInstance();
            this.transformer = tf.newTransformer();
        }
        catch (Exception e) {
            throw new NullPointerException("Cannot find secure provider name " + providerName);
        }
    }

    public XMLSignedData(Document doc) {
        this();
        this.doc = doc;
    }

    public XMLSignedData(XMLData data) {
        this(data.getDocument());
    }

    public XMLSignedData(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        this();
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        this.doc = db.parse(in);
        in.close();
    }

    public XMLSignedData(byte[] data) throws ParserConfigurationException, IOException, SAXException {
        this(new ByteArrayInputStream(data));
    }

    public XMLSignedData(String fileName) throws ParserConfigurationException, IOException, SAXException {
        this(new FileInputStream(fileName));
    }

    public Document getDocument() {
        return this.doc;
    }

    public void addDigestAlgo(AlgorithmProfile dgsAlg) {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }

    public void addSigner(RawSignerInfo signer) {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }

    public RawContentInfo getContentInfo() {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }

    public byte[] getCRLs() {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }

    public byte[] getData() {
        try {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer ts = tf.newTransformer();
            ts.transform(new DOMSource(this.doc), new StreamResult(buff));
            return buff.toByteArray();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Iterator getDigestAlgos() {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }

    public RawSignerInfo getSignerInfo(CertProfile signerCert) throws SecurePackageVerifyFailException {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }

    public Iterator getSigners() {
        NodeList nl;
        X509KeySelector keySelector = new X509KeySelector();
        ArrayList<XMLSignerInfo> signers = new ArrayList<XMLSignerInfo>();
        if (this.doc != null && (nl = this.doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature")).getLength() > 0) {
            int n = 0;
            while (n < nl.getLength()) {
                try {
                    DOMValidateContext vContext = new DOMValidateContext(keySelector, nl.item(n));
                    XMLSignature signature = this.xMLSignatureFactory.unmarshalXMLSignature(vContext);
                    X509Certificate xCert = keySelector.getSignerCertificate(signature.getKeyInfo(), vContext);
                    CertProfile cert = new CertProfile(xCert);
                    byte[] signatureValue = signature.getSignatureValue().getValue();
                    String algorithmName = signature.getSignedInfo().getSignatureMethod().getAlgorithm();
                    String signingTimeStr = "";
                    Node signingTimeNode = XMLSigningTime.getTimeStampeNode(nl.item(n));
                    if (signingTimeNode != null) {
                        XMLSigningTime signingTime = new XMLSigningTime(signingTimeNode);
                        signingTimeStr = signingTime.getTime();
                    }
                    XMLSignerInfo signer = new XMLSignerInfo(cert, signatureValue, algorithmName, signingTimeStr, nl.item(n));
                    signers.add(signer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n;
            }
            return signers.iterator();
        }
        return null;
    }

    public int getVersion() {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }

    public void setData(byte[] data) {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            this.doc = db.parse(new ByteArrayInputStream(data));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVersion(int v) {
        throw new IllegalArgumentException("Do not required this operation for XML-Security ");
    }
}

