/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.XML;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Packaging.RawSignerInfo;

public class XMLSignerInfo
extends RawSignerInfo {
    private Node signatureNode;
    private String signingTime = "";

    public XMLSignerInfo(CertProfile signer, byte[] signature, String algoName, String signingTime, Node node) {
        this.setSignerCertificate(signer);
        this.setSignature(signature);
        this.setAlgorithm(new AlgorithmProfile("NA", algoName));
        this.signingTime = signingTime;
        this.signatureNode = node;
    }

    public String getText() {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer ts = tf.newTransformer();
            ts.setOutputProperty("indent", "yes");
            ts.setOutputProperty("omit-xml-declaration", "yes");
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            ts.transform(new DOMSource(this.signatureNode), new StreamResult(buff));
            return buff.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getSigningTime() {
        return this.signingTime;
    }

    XMLSignerInfo() {
    }

    public XMLSignerInfo(byte[] signature, AlgorithmProfile algo, CertProfile signer, Node node) {
        super(signature, algo, signer);
    }
}

