/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.XML;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSigningTime
extends DOMStructure {
    public static SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssZ");
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static boolean trace = false;

    public XMLSigningTime(Node node) {
        super(node);
    }

    public static XMLSigningTime getInstance(DOMStructure dom) {
        return new XMLSigningTime(dom.getNode());
    }

    public static Node getTimeStampeNode(Node node) {
        NodeList nl = ((Element)node).getElementsByTagNameNS("http://www.ietf.org/rfc/rfc3369.txt#", "SigningTime");
        if (trace) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer ts = tf.newTransformer();
                ts.setOutputProperty("indent", "yes");
                System.out.println("Time stamp element");
                ts.transform(new DOMSource(nl.item(0)), new StreamResult(System.out));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nl.item(0);
    }

    public String getTime() throws ParseException {
        Node node = this.getNode();
        Node valueNode = node.getFirstChild();
        if (valueNode == null) {
            String gTime;
            NodeList nl = ((Element)node).getElementsByTagNameNS("http://www.ietf.org/rfc/rfc3369.txt#", "GeneralizedTime");
            if (nl == null) {
                nl = ((Element)node).getElementsByTagName("GeneralizedTime");
            }
            if (nl != null && (gTime = nl.item(0).getFirstChild().getNodeValue()) != null) {
                return DATE_FORMAT.format(TIME_FORMAT.parse(gTime));
            }
        } else {
            String gTime;
            if (valueNode.getNodeType() == 3 && (gTime = valueNode.getNodeValue()) != null) {
                return DATE_FORMAT.format(TIME_FORMAT.parse(gTime));
            }
            if (valueNode.getNodeType() == 1 && (gTime = valueNode.getTextContent()) != null) {
                return DATE_FORMAT.format(TIME_FORMAT.parse(gTime));
            }
        }
        return "";
    }

    public Date getDate() throws ParseException {
        String t = this.getTime();
        if (!t.equals("")) {
            return DATE_FORMAT.parse(t);
        }
        return null;
    }

    public static XMLSigningTime getInstance(Calendar date, boolean reqPrefix) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        doc.setXmlStandalone(false);
        Element signingTime = doc.createElementNS("http://www.ietf.org/rfc/rfc3369.txt#", "SigningTime");
        if (reqPrefix) {
            signingTime.setPrefix("dsigtime");
        }
        Element timeNode = doc.createElementNS("http://www.ietf.org/rfc/rfc3369.txt#", "GeneralizedTime");
        if (reqPrefix) {
            timeNode.setPrefix("dsigtime");
        }
        timeNode.appendChild(doc.createTextNode(TIME_FORMAT.format(date.getTime())));
        signingTime.appendChild(timeNode);
        doc.appendChild(signingTime);
        doc.normalizeDocument();
        return new XMLSigningTime(signingTime);
    }

    public boolean isFeatureSupported(String arg0) {
        return super.isFeatureSupported(arg0);
    }

    public Node getNode() {
        Node node = super.getNode();
        if (trace) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer ts = tf.newTransformer();
                ts.setOutputProperty("indent", "yes");
                System.out.println("Time stamp element");
                ts.transform(new DOMSource(node), new StreamResult(System.out));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return node;
    }
}

