/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.service;

import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.service.ServiceEvent;
import th.co.oga.security.pki.service.ServiceTask;

public class RoomConfigUpdater
extends ServiceTask {
    Room room;

    public RoomConfigUpdater(Room room) {
        super(String.valueOf(room.getOwner().getName()) + "'s Room configuration updater");
        this.room = room;
    }

    void update() {
        try {
            if (this.room.reloadCRL()) {
                this.setEvent(ServiceEvent.getInfoEvent(ServiceEvent.EVENT_STATUS_SLEEP, "finish load CRL Register on new update", this));
            }
        }
        catch (Exception e) {
            this.setEvent(ServiceEvent.getCriticalEvent(ServiceEvent.EVENT_STATUS_FAIL, " Error while load new CRL Register table ", this));
        }
        try {
            if (this.room.updateRoomConfig()) {
                this.setEvent(ServiceEvent.getInfoEvent(ServiceEvent.EVENT_STATUS_SLEEP, "finish load Room Configuration on new update", this));
            }
        }
        catch (Exception e) {
            this.setEvent(ServiceEvent.getCriticalEvent(ServiceEvent.EVENT_STATUS_FAIL, " Error while load new Room Configuration ", this));
        }
        try {
            if (this.room.reloadOwner()) {
                this.setEvent(ServiceEvent.getInfoEvent(ServiceEvent.EVENT_STATUS_SLEEP, "finish reload agent configuration", this));
            }
        }
        catch (Exception e) {
            this.setEvent(ServiceEvent.getCriticalEvent(ServiceEvent.EVENT_STATUS_FAIL, " Error while reload agent configuration ", this));
        }
    }
}

