/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.service.RoomConfigUpdater;
import th.co.oga.security.pki.service.ServiceEvent;
import th.co.oga.security.pki.service.ServiceMonitor;
import th.co.oga.security.pki.service.ServiceTask;
import th.co.oga.security.pki.service.TaskList;
import th.co.oga.security.pki.service.TaskMonitor;

public class RoomServiceDeamond
implements Runnable,
TaskMonitor {
    private ServiceMonitor monitor;
    private TaskList taskList;
    private Room room;
    private Logger logger;
    private Timer timer;
    private boolean still = true;

    public RoomServiceDeamond(Room room) {
        this.logger = room.getLogger();
        this.logger.info((Object)"Start Online Service Daemon...");
        this.taskList = new TaskList();
        RoomConfigUpdater roomUpdater = new RoomConfigUpdater(room);
        roomUpdater.setMonitor(this);
        this.taskList.setTask(roomUpdater);
        this.logger.info((Object)"Process schedule tasks.");
        int interval = 60000;
        int delay = 0;
        this.timer = new Timer(true);
        Iterator taskNames = this.taskList.getTaskNames();
        while (taskNames.hasNext()) {
            ServiceTask task = (ServiceTask)this.taskList.get(taskNames.next());
            this.logger.info((Object)("Launch task :" + task.getName()));
            this.timer.scheduleAtFixedRate((TimerTask)task, delay += 5000, (long)interval);
        }
    }

    public void stop() {
        this.still = false;
        this.logger.info((Object)"Cancel all task in schedule ...");
        Iterator taskNames = this.taskList.getTaskNames();
        while (taskNames.hasNext()) {
            ((ServiceTask)this.taskList.get(taskNames.next())).cancel();
        }
        this.logger.info((Object)"Stop schedule.");
        this.timer.cancel();
    }

    public void addServiceTask(ServiceTask task) {
        this.addIntervalTask(task, 1, 30);
        if (!task.isMonitored()) {
            task.setMonitor(this);
        }
    }

    public void addIntervalTask(ServiceTask task, int delaySecond, int intervalSecond) {
        ServiceTask oTask = (ServiceTask)this.taskList.get(task.getName());
        if (oTask == null) {
            this.taskList.setTask(task);
            this.timer.scheduleAtFixedRate((TimerTask)task, 1000 * delaySecond, (long)(1000 * intervalSecond));
            this.setRessEvent(ServiceEvent.getInfoEvent(ServiceEvent.EVENT_REQ_RESTART, "Add to room service.", task));
        }
    }

    public void removeTask(ServiceTask task) {
        ServiceTask oTask = (ServiceTask)this.taskList.get(task.getClass());
        if (oTask != null) {
            this.taskList.remove(task.getName());
            oTask.cancel();
            this.setRessEvent(ServiceEvent.getInfoEvent(ServiceEvent.EVENT_REQ_STOP, "Remove from room service.", oTask));
        }
    }

    public void run() {
        this.logger.info((Object)"Deamon subsystem start.");
        while (this.still) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Deamon subsystem error while try to sleep ...");
            }
        }
        this.logger.info((Object)"Deamon subsystem stop.");
    }

    public void setServiceMonitor(ServiceMonitor monitor) {
        this.monitor = monitor;
    }

    public void setTaskEvent(ServiceEvent event) {
        this.setRessEvent(event);
    }

    public void setRessEvent(ServiceEvent event) {
        int errorLevel = event.getLevel();
        if (errorLevel == 0) {
            this.logger.info((Object)event.toString());
        } else if (errorLevel == 1) {
            this.logger.warn((Object)event.toString());
        } else if (errorLevel == 2) {
            this.logger.fatal((Object)event.toString());
        }
        if (this.monitor != null) {
            this.monitor.setEvent(event);
        }
    }

    protected void handleConnection(Socket server) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(server.getInputStream()));
        PrintWriter out = new PrintWriter(server.getOutputStream(), true);
        this.logger.info((Object)("CLIENT: " + server.getInetAddress().getHostName()));
        String str = in.readLine();
        this.logger.info((Object)("CLIENT: says " + str));
        if (str.startsWith("PING")) {
            this.logger.info((Object)"REPLY: PONG");
            out.println("PONG");
        } else if (str.startsWith("UPDATE")) {
            this.logger.info((Object)"REPLY: UPDATED");
            out.println("UPDATED");
        }
        server.close();
    }
}

