/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import th.co.oga.security.pki.service.ServiceTask;

public class ServiceEvent {
    public static int LEVEL_INFO = 0;
    public static int LEVEL_WARNING = 1;
    public static int LEVEL_CRITICAL = 2;
    public static int TYPE_RESPONSE = 10;
    public static int TYPE_REQUEST = 11;
    public static int EVENT_STATUS_SLEEP = 20;
    public static int EVENT_STATUS_RUNNING = 21;
    public static int EVENT_STATUS_FAIL = 22;
    public static int EVENT_REQ_START = 110;
    public static int EVENT_REQ_STOP = 111;
    public static int EVENT_REQ_RESTART = 112;
    private int level = 0;
    private int eventNo = 20;
    private ServiceTask source;
    private String info;
    private Date eventDate = Calendar.getInstance().getTime();

    protected ServiceEvent() {
    }

    public static ServiceEvent getInfoEvent(int status, String info, ServiceTask source) {
        ServiceEvent event = new ServiceEvent();
        event.setEventLevel(LEVEL_INFO);
        event.setEventNo(status);
        event.setEventInfo(info);
        event.setEventSource(source);
        return event;
    }

    public static ServiceEvent getWarningEvent(int status, String info, ServiceTask source) {
        ServiceEvent event = new ServiceEvent();
        event.setEventLevel(LEVEL_WARNING);
        event.setEventNo(status);
        event.setEventInfo(info);
        event.setEventSource(source);
        return event;
    }

    public static ServiceEvent getCriticalEvent(int status, String info, ServiceTask source) {
        ServiceEvent event = new ServiceEvent();
        event.setEventLevel(LEVEL_CRITICAL);
        event.setEventNo(status);
        event.setEventInfo(info);
        event.setEventSource(source);
        return event;
    }

    public static ServiceEvent getStartCommandEvent() {
        ServiceEvent event = new ServiceEvent();
        event.setEventLevel(0);
        event.setEventNo(EVENT_REQ_START);
        return event;
    }

    public static ServiceEvent getStopCommandEvent() {
        ServiceEvent event = new ServiceEvent();
        event.setEventLevel(0);
        event.setEventNo(EVENT_REQ_STOP);
        return event;
    }

    public static ServiceEvent getRestartCommandEvent() {
        ServiceEvent event = new ServiceEvent();
        event.setEventLevel(0);
        event.setEventNo(EVENT_REQ_RESTART);
        return event;
    }

    protected void setEventLevel(int level) {
        this.level = level;
    }

    protected void setEventNo(int no) {
        this.eventNo = no;
    }

    protected void setEventSource(ServiceTask s) {
        this.source = s;
    }

    protected void setEventInfo(String info) {
        this.info = info;
    }

    public Object getSource() {
        return this.source;
    }

    public String getInfo() {
        return this.info;
    }

    public int getLevel() {
        return this.level;
    }

    public String getEventTime() {
        return new SimpleDateFormat("dd-MM-yyyy hh.mm.ss").format(this.eventDate);
    }

    public String toString() {
        return String.valueOf(this.getEventLevel()) + " : " + this.getEventStatus() + " : " + this.getEventTime() + " : " + this.source.getName() + " : " + this.getInfo();
    }

    public String getEventLevel() {
        if (this.level == LEVEL_INFO) {
            return "Infomation";
        }
        if (this.level == LEVEL_WARNING) {
            return "Warnning";
        }
        if (this.level == LEVEL_CRITICAL) {
            return "Critical";
        }
        return "Unknow";
    }

    public String getEventStatus() {
        if (this.eventNo == EVENT_STATUS_SLEEP) {
            return "Sleep";
        }
        if (this.eventNo == EVENT_STATUS_RUNNING) {
            return "Running";
        }
        if (this.eventNo == EVENT_STATUS_FAIL) {
            return "Fail";
        }
        return "Undefine";
    }
}

