/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.service;

import java.util.TimerTask;
import th.co.oga.security.pki.service.ServiceEvent;
import th.co.oga.security.pki.service.TaskMonitor;

public abstract class ServiceTask
extends TimerTask {
    private int state = 0;
    private int status = 0;
    private TaskMonitor monitor;
    private String taskName;
    private int counter = 50;

    public ServiceTask(String name) {
        this.taskName = name;
    }

    public void setMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    protected void setEvent(ServiceEvent event) {
        if (this.monitor != null) {
            this.monitor.setTaskEvent(event);
        }
    }

    private void begin() {
        ++this.counter;
        if (this.counter > 50) {
            this.setEvent(ServiceEvent.getInfoEvent(ServiceEvent.EVENT_STATUS_RUNNING, String.valueOf(this.taskName) + " take begine @ " + this.counter + " time task operation.", this));
        }
        this.status = 1;
    }

    private void end() {
        if (this.counter > 50) {
            this.setEvent(ServiceEvent.getInfoEvent(ServiceEvent.EVENT_STATUS_SLEEP, String.valueOf(this.taskName) + " take at end of @ " + this.counter + " time task operation.", this));
            this.counter = 0;
        }
        this.status = 0;
    }

    public String getName() {
        return this.taskName;
    }

    public boolean isRunning() {
        return this.status == 1;
    }

    public void run() {
        if (this.status == 0) {
            this.begin();
            this.update();
            this.end();
        }
    }

    public boolean isMonitored() {
        return this.monitor != null;
    }

    abstract void update();
}

