/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.CRL;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;
import th.co.oga.security.pki.x.CRL.CRLProfile;
import th.co.oga.security.pki.x.CRL.CRLTrnsHeader;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;

public class CRLDataPackage
implements PKIDataPackage {
    private CRLProfile crl;
    private PKITrnsHeader header = new CRLTrnsHeader();

    public CRLProfile getCRL() {
        return this.crl;
    }

    public static CRLDataPackage getInstance() {
        return new CRLDataPackage();
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        try {
            this.crl = CRLProfile.decode(in);
        }
        catch (CRLException e) {
            throw new TransportPackageEncodingFailException(e);
        }
        catch (CertificateException e) {
            throw new TransportPackageEncodingFailException(e);
        }
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        try {
            this.crl.encode(out);
        }
        catch (CRLException e) {
            throw new TransportPackageEncodingFailException(e);
        }
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader header) {
        this.header.setTrnsHeader(header);
    }
}

