/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.CRL;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class CRLProfile
implements XMLRecord {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z", new Locale("en", "TH"));
    private String authorityName = null;
    private String lastUpdate = null;
    private String nextUpdate = null;
    private X509CRL crl = null;
    private boolean registered = false;
    private boolean loaded = false;
    private long fileDate = 0L;
    private String fileName = null;

    public CRLProfile(X509CRL crl) {
        this.crl = crl;
        this.authorityName = crl.getIssuerX500Principal().toString();
        this.lastUpdate = this.dateFormat.format(crl.getThisUpdate());
        this.fileName = String.valueOf(crl.getIssuerX500Principal().hashCode()) + ".crl";
        Date nextDate = crl.getNextUpdate();
        if (nextDate != null) {
            this.nextUpdate = this.dateFormat.format(nextDate);
        }
        this.setLoaded();
    }

    public CRLProfile(Node node) throws XMLRecordDataException {
        this.setXMLRecord(node);
    }

    public boolean isOlder(CRLProfile newProfile) {
        return this.crl.getThisUpdate().before(newProfile.crl.getThisUpdate());
    }

    public void retuch(String srcFileName) throws IOException, CertificateException, CRLException {
        Date recDate;
        Date orgDate;
        File crlFile = new File(srcFileName);
        if (crlFile.isFile() && crlFile.exists() && crlFile.canRead() && (orgDate = new Date(crlFile.lastModified())).after(recDate = new Date(this.fileDate))) {
            this.load(srcFileName);
        }
    }

    public void load(String src) throws IOException, CertificateException, CRLException {
        File crlFile = new File(src);
        this.read(new FileInputStream(crlFile));
        this.fileDate = crlFile.lastModified();
    }

    public void read(InputStream in) throws IOException, CertificateException, CRLException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.crl = (X509CRL)cf.generateCRL(in);
        this.setLoaded();
    }

    public void setLoaded() {
        this.loaded = true;
    }

    public void setFileDate(long lastModify) {
        this.fileDate = lastModify;
    }

    public void saveFile(String src) throws IOException, FileNotFoundException, CRLException {
        block6: {
            boolean doIt = false;
            boolean begin = false;
            String backupFile = String.valueOf(src) + ".bck";
            File srcFile = new File(src);
            if (srcFile.exists() && srcFile.canWrite()) {
                Date recDate;
                Date orgDate = new Date(srcFile.lastModified());
                if (orgDate.before(recDate = new Date(this.fileDate))) {
                    begin = true;
                    File bkFile = new File(backupFile);
                    bkFile.deleteOnExit();
                    srcFile.renameTo(bkFile);
                    doIt = true;
                }
            } else {
                srcFile.createNewFile();
                doIt = true;
            }
            if (doIt) {
                try {
                    FileOutputStream out = new FileOutputStream(src);
                    out.write(this.crl.getEncoded());
                    out.close();
                    File file = new File(src);
                    this.fileDate = file.lastModified();
                }
                catch (Exception e) {
                    if (!begin) break block6;
                    File rvFile = new File(backupFile);
                    rvFile.renameTo(new File(src));
                }
            }
        }
    }

    public X509CRLEntry getRevokedCert(CertProfile cert) {
        return this.crl.getRevokedCertificate(cert.getSerialNumber());
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static CRLProfile getInstance(byte[] bytes) throws IOException, CertificateException, CRLException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        X509CRL crl = (X509CRL)cf.generateCRL(stream);
        return new CRLProfile(crl);
    }

    public static CRLProfile decode(InputStream in) throws IOException, CertificateException, CRLException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509CRL crl = (X509CRL)cf.generateCRL(in);
        return new CRLProfile(crl);
    }

    public static String getCRLIssuerName(CertProfile cert) throws ASN1Exception {
        if (cert.isCA()) {
            return cert.getX509Cert().getSubjectX500Principal().toString();
        }
        return cert.getX509Cert().getIssuerX500Principal().toString();
    }

    public X500Principal getIssueName() {
        return this.crl.getIssuerX500Principal();
    }

    public String getAuthorityName() {
        return this.authorityName;
    }

    public Date getLastUpdate() throws ParseException {
        return this.dateFormat.parse(this.lastUpdate);
    }

    public X509CRL getCRL() {
        return this.crl;
    }

    public void encode(OutputStream out) throws CRLException, IOException {
        out.write(this.crl.getEncoded());
    }

    public InputStream getInputStream() throws CRLException {
        return new ByteArrayInputStream(this.crl.getEncoded());
    }

    public String getParentElementName() {
        return CryptOGAFormat.CRL_PRF_PARENT;
    }

    public String getElementName() {
        return CryptOGAFormat.CRL_PRF;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        CRLProfile csrProfile = new CRLProfile(node);
        return this.authorityName.equals(csrProfile.getAuthorityName());
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("CRLProfile", " Empty node was supplied " + node.toString());
        }
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.CRL_PRF_AUTHORITY)) {
                        this.authorityName = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CRL_PRF_LAST_DATE)) {
                        this.lastUpdate = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CRL_PRF_NEXT_DATE)) {
                        this.nextUpdate = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CRL_PRF_FILE_NAME)) {
                        this.fileName = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CRL_PRF_FILE_DATE)) {
                        this.fileDate = new BigInteger(nv).longValue();
                    }
                }
                ++i;
            }
            this.registered = true;
        }
        catch (Exception e) {
            throw new XMLRecordDataException("CRLProfile", e.toString());
        }
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(this.getElementName());
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CRL_PRF_AUTHORITY, this.authorityName));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CRL_PRF_LAST_DATE, this.lastUpdate));
        if (this.nextUpdate != null) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CRL_PRF_NEXT_DATE, this.nextUpdate));
        }
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CRL_PRF_FILE_NAME, this.fileName));
        if (this.fileDate > 0L) {
            parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CRL_PRF_FILE_DATE, "" + this.fileDate));
        }
        return parent;
    }
}

