/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.CRL;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class CRLReason
implements ASN1Value {
    public static int unspecified = 0;
    public static int keyCompromise = 1;
    public static int cACompromise = 2;
    public static int affiliationChanged = 3;
    public static int superseded = 4;
    public static int cessationOfOperation = 5;
    public static int certificateHold = 6;
    public static int removeFromCRL = 8;
    public static int privilegeWithdrawn = 9;
    public static int aACompromise = 10;
    public static ENUMERATED[] reasons = new ENUMERATED[]{new ENUMERATED(0L), new ENUMERATED(2L), new ENUMERATED(3L), new ENUMERATED(4L), new ENUMERATED(5L), new ENUMERATED(6L), new ENUMERATED(7L), new ENUMERATED(8L), new ENUMERATED(9L), new ENUMERATED(10L)};
    private String[] reasonTexts;
    private ENUMERATED reasonCode;
    public static final Tag TAG = ENUMERATED.TAG;
    private static final Template TEMPLATE = new Template();

    protected CRLReason(ENUMERATED reasonCode) {
        String[] stringArray = new String[11];
        stringArray[0] = "Unspecified";
        stringArray[1] = "Key Compromise";
        stringArray[2] = "CA Compromise";
        stringArray[3] = "Affiliation Changed";
        stringArray[4] = "Superseded";
        stringArray[5] = "Cessation Of Operation";
        stringArray[6] = "Certificate Hold";
        stringArray[8] = "Remove From CRL";
        stringArray[9] = "privilegeWithdrawn";
        stringArray[10] = "AA Compromise";
        this.reasonTexts = stringArray;
        this.reasonCode = reasonCode;
    }

    public CRLReason(int reasonCode) {
        String[] stringArray = new String[11];
        stringArray[0] = "Unspecified";
        stringArray[1] = "Key Compromise";
        stringArray[2] = "CA Compromise";
        stringArray[3] = "Affiliation Changed";
        stringArray[4] = "Superseded";
        stringArray[5] = "Cessation Of Operation";
        stringArray[6] = "Certificate Hold";
        stringArray[8] = "Remove From CRL";
        stringArray[9] = "privilegeWithdrawn";
        stringArray[10] = "AA Compromise";
        this.reasonTexts = stringArray;
        this.reasonCode = reasons[reasonCode];
    }

    public String getReasonText() {
        return this.reasonTexts[this.reasonCode.intValue()];
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.reasonCode.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt;

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            ENUMERATED enu = (ENUMERATED)ENUMERATED.getTemplate().decode(implicit, istream);
            return new CRLReason(enu);
        }
    }
}

