/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.CSR;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;
import th.co.oga.security.pki.x.CSR.CSRReqHeader;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;

public class CSRDataPackage
implements PKIDataPackage {
    private CSRProfile csr;
    private PKITrnsHeader header = new CSRReqHeader();

    public CSRDataPackage(CSRProfile csr) {
        this.csr = csr;
    }

    public static CSRDataPackage getInstnce(CSRProfile csr) {
        return new CSRDataPackage(csr);
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        try {
            this.csr = format.equals(TransportEncodeFormat.PEM) ? CSRProfile.base64Decode(in) : CSRProfile.decode(in);
        }
        catch (ASN1Exception e) {
            throw new TransportPackageEncodingFailException(e);
        }
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        if (format.equals(TransportEncodeFormat.PEM)) {
            this.csr.base64Encode(out);
        } else {
            this.csr.encode(out);
        }
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader header) {
        this.header.setTrnsHeader(header);
    }
}

