/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.CSR;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;
import th.co.oga.security.pki.x.CSR.CertDeliveryHeader;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;

public class CertDeliveryPackage
implements PKIDataPackage {
    private CertProfile cert;
    private PKITrnsHeader header = new CertDeliveryHeader();

    public CertDeliveryPackage(CertProfile cert) {
        this.cert = cert;
    }

    public CertDeliveryPackage() {
        this.cert = null;
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        try {
            this.cert = CertProfile.decode(in);
        }
        catch (CertificateException e) {
            throw new TransportPackageEncodingFailException(e);
        }
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        this.cert.encode(out);
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader header) {
        this.header.setTrnsHeader(header);
    }
}

