/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.Name;

public class DirectoryName
implements ASN1Value {
    private ASN1Value name;
    private static final Template TEMPLATE = new Template();

    public DirectoryName(Name name) {
        this.name = name;
    }

    protected DirectoryName(ASN1Value name) throws InvalidBERException {
        this.name = name;
    }

    public ASN1Value getValue() {
        return this.name;
    }

    public String getData() throws InvalidBERException {
        return ((Name)this.name).getRFC1485();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.name.encode(implicit, ostream);
    }

    public Tag getTag() {
        return this.name.getTag();
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template cTP = CHOICE.getTemplate();

        public Template() {
            this.cTP.addElement((ASN1Template)ANY.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.cTP.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.cTP.decode(istream);
            ANY any = (ANY)choice.getValue();
            Name xname = (Name)ASN1Util.decode((ASN1Template)Name.getTemplate(), (byte[])any.getContents());
            return new DirectoryName(xname);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            return this.decode(istream);
        }
    }
}

