/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;
import th.co.oga.security.pki.Certification.Extension.VisibleString;

public class DisplayText
implements ASN1Value {
    private ASN1Value gn;
    private static final Template TEMPLATE = new Template();

    protected DisplayText(ASN1Value generalName) throws InvalidBERException {
        this.gn = generalName;
    }

    public ASN1Value getValue() {
        return this.gn;
    }

    public String getData() throws InvalidBERException {
        String data = "";
        if (this.gn instanceof VisibleString) {
            data = ((VisibleString)this.gn).toString();
        } else if (this.gn instanceof BMPString) {
            data = ((BMPString)this.gn).toString();
        } else if (this.gn instanceof UTF8String) {
            data = ((UTF8String)this.gn).toString();
        }
        return data;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.gn.encode(implicit, ostream);
    }

    public Tag getTag() {
        return this.gn.getTag();
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template cTP = CHOICE.getTemplate();

        public Template() {
            this.cTP.addElement((ASN1Template)new VisibleString.Template());
            this.cTP.addElement((ASN1Template)new BMPString.Template());
            this.cTP.addElement((ASN1Template)new UTF8String.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.cTP.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.cTP.decode(istream);
            return new DisplayText(choice.getValue());
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            return this.decode(istream);
        }
    }
}

