/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.Certification.Extension.NumericString;

public class DomainName
implements ASN1Value {
    private ASN1Value dn;
    private static final Template TEMPLATE = new Template();

    public DomainName(NumericString numeric) {
        this.dn = numeric;
    }

    public DomainName(PrintableString string) {
        this.dn = string;
    }

    protected DomainName(ASN1Value generalName) throws InvalidBERException {
        this.dn = generalName;
    }

    public ASN1Value getValue() {
        return this.dn;
    }

    public String getData() throws InvalidBERException {
        if (this.dn instanceof PrintableString) {
            return ((PrintableString)this.dn).toString();
        }
        return ((NumericString)this.dn).getData();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.dn.encode(implicit, ostream);
    }

    public Tag getTag() {
        return this.dn.getTag();
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template cTP = CHOICE.getTemplate();

        public Template() {
            this.cTP.addElement((ASN1Template)new PrintableString.Template());
            this.cTP.addElement((ASN1Template)new NumericString.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.cTP.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.cTP.decode(istream);
            return new DomainName(choice.getValue());
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            Assert._assert((boolean)this.tagMatch(implicitTag));
            return this.decode(istream);
        }
    }
}

