/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.OIDs;

public class ExtendedKeyUsages
implements ASN1Value {
    public static OBJECT_IDENTIFIER SERVER_AUTHEN = new OBJECT_IDENTIFIER(OIDs.kpServerAuth);
    public static OBJECT_IDENTIFIER CLIENT_AUTHEN = new OBJECT_IDENTIFIER(OIDs.kpclientAuth);
    public static OBJECT_IDENTIFIER CODE_SIGNING = new OBJECT_IDENTIFIER(OIDs.kpCodeSigning);
    public static OBJECT_IDENTIFIER EMAIL_PROTECTION = new OBJECT_IDENTIFIER(OIDs.kpEmailProtection);
    public static OBJECT_IDENTIFIER TIMESTAMPING = new OBJECT_IDENTIFIER(OIDs.kpTimeStamping);
    public static OBJECT_IDENTIFIER OCSP_SIGNING = new OBJECT_IDENTIFIER(OIDs.kpOCSPSigning);
    private OBJECT_IDENTIFIER[] oids;
    private String[] pureposes;
    private BitSet map = new BitSet(6);
    public static final Tag TAG = SEQUENCE.TAG;

    private ExtendedKeyUsages() {
        this.oids = new OBJECT_IDENTIFIER[]{SERVER_AUTHEN, CLIENT_AUTHEN, CODE_SIGNING, EMAIL_PROTECTION, TIMESTAMPING, OCSP_SIGNING};
        this.pureposes = new String[]{"ServerAuthen", "ClientAuthen", "CodeSigning", "sMIME", "Timestamping", "OCSPSigning"};
    }

    ExtendedKeyUsages(SEQUENCE seq) {
        this();
        int s = 0;
        while (s < seq.size()) {
            this.enable((OBJECT_IDENTIFIER)seq.elementAt(s));
            ++s;
        }
    }

    public void enable(OBJECT_IDENTIFIER oid) {
        int o = 0;
        while (o < this.oids.length) {
            if (this.oids[o].equals((Object)oid)) {
                this.map.set(o);
                break;
            }
            ++o;
        }
    }

    public String getKeyPurePoses() {
        String rtn = "";
        int k = 0;
        while (k < this.map.size()) {
            if (this.map.get(k)) {
                if (rtn.length() > 0) {
                    rtn = String.valueOf(rtn) + ", ";
                }
                rtn = String.valueOf(rtn) + this.pureposes[k];
            }
            ++k;
        }
        return rtn;
    }

    public static ExtendedKeyUsages getInstance(byte[] bytes) throws InvalidBERException {
        OCTET_STRING oc = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])bytes);
        Template reader = new Template();
        return (ExtendedKeyUsages)ASN1Util.decode((ASN1Template)reader, (byte[])oc.toByteArray());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        int k = 0;
        while (k < this.map.size()) {
            if (this.map.get(k)) {
                seq.addElement((ASN1Value)this.oids[k]);
            }
            ++k;
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.OF_Template seqq = new SEQUENCE.OF_Template((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            SEQUENCE seq = (SEQUENCE)seqq.decode(implicit, istream);
            return new ExtendedKeyUsages(seq);
        }
    }
}

