/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.FileUpload;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import th.co.oga.security.pki.Transport.HTTPConnector;
import th.co.oga.security.pki.Transport.InvalidProtocolNameException;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.ProtocolName;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.x.FileUpload.FileUploadDataPackage;
import th.co.oga.security.pki.x.PKITrnsPackage;

public class FileUploadClient {
    private FileUploadDataPackage reqPkg;
    private AuthorityService as;
    private PKITrnsPackage trnsPkg;

    public FileUploadClient(URL url) throws InvalidProtocolNameException {
        this.as = new AuthorityService(ServiceName.FILEUPLOAD);
        this.as.setURL(url);
    }

    public FileUploadClient(String host, String part, int port) {
        this.as = new AuthorityService(ServiceName.FILEUPLOAD, ProtocolName.HTTP, host, part);
        this.as.setPort(port);
    }

    public FileUploadClient(String host, String part) {
        this(host, part, 80);
    }

    public void setAuthen(String user, String password) {
        this.as.setAuthen(new PasswordAuthentication(user, password.toCharArray()));
    }

    public void setTargetFileName(String fileName) {
        this.reqPkg.getHeader().setFileName(fileName);
    }

    public void transfer() throws UnSupportProtocolException, IOException {
        this.trnsPkg = new PKITrnsPackage(this.reqPkg, new FileUploadDataPackage());
        HTTPConnector conn = new HTTPConnector(this.as.getAuthen(), this.as.getStringUrl());
        conn.setTraceMode(true);
        conn.setContentType(this.trnsPkg.getContentType());
        conn.send(this.trnsPkg);
        conn.receive(this.trnsPkg);
    }

    public void setRequest(String fileName) throws FileNotFoundException, IOException {
        this.reqPkg = new FileUploadDataPackage(fileName);
    }

    public void setRequest(FileUploadDataPackage pkg) {
        this.reqPkg = pkg;
    }

    public FileUploadDataPackage getResponse() throws IOException {
        return (FileUploadDataPackage)this.trnsPkg.getResponsePackage();
    }
}

