/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.FileUpload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.x.FileUpload.FileUploadHeader;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;

public class FileUploadDataPackage
implements PKIDataPackage {
    private ByteArrayOutputStream buff;
    private PKITrnsHeader header = new FileUploadHeader();

    public static FileUploadDataPackage getInstance() {
        return new FileUploadDataPackage();
    }

    public FileUploadDataPackage() {
        this.buff = new ByteArrayOutputStream();
    }

    public OutputStream getOutputStream() {
        return this.buff;
    }

    public FileUploadDataPackage(String fileName) throws FileNotFoundException, IOException {
        this();
        int b;
        File file = new File(fileName);
        FileInputStream in = new FileInputStream(file);
        while ((b = in.read()) > -1) {
            this.buff.write(b);
        }
        in.close();
        this.header.setFileName(file.getName());
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        int b;
        this.buff = new ByteArrayOutputStream();
        while ((b = in.read()) > -1) {
            this.buff.write(b);
        }
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        out.write(this.buff.toByteArray());
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader header) {
        this.header.setTrnsHeader(header);
    }

    public PKITrnsHeader getTrnsHeader() {
        return this.header;
    }
}

