/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class KeyUsages
implements ASN1Value {
    public static final int KEY_USAGE_DIGITAL_SIGNATURE = 0;
    public static final int KEY_USAGE_NON_REPUDIATION = 1;
    public static final int KEY_USAGE_KEY_ENCIPHERMENT = 2;
    public static final int KEY_USAGE_DATA_ENCIPHERMENT = 3;
    public static final int KEY_USAGE_KEY_AGREEMENT = 4;
    public static final int KEY_USAGE_KEY_CERT_SIGN = 5;
    public static final int KEY_USAGE_KEY_CRL_SIGN = 6;
    public static final int KEY_USAGE_ENCIPHER_ONLY = 7;
    public static final int KEY_USAGE_DECIPHER_ONLY = 8;
    private BitSet usages = new BitSet(9);
    public static Tag TAG = BIT_STRING.TAG;
    private static final Template TEMPLATE = new Template();

    private KeyUsages(BIT_STRING bs) {
        this.usages = bs.toBitSet();
    }

    public KeyUsages() {
        this.usages.set(0, 9, false);
    }

    public KeyUsages(boolean[] usages) {
        if (usages == null) {
            int i = 0;
            while (i < 9) {
                this.usages.set(i, false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 9) {
                this.usages.set(i, usages[i]);
                ++i;
            }
        }
    }

    public void setKeyUsages(int keyUsageParam, boolean value) {
        this.usages.set(keyUsageParam, value);
    }

    public boolean canSignData() {
        return this.usages.get(0);
    }

    public boolean canSignCriticalData() {
        return this.usages.get(1);
    }

    public boolean canSignCert() {
        return this.usages.get(5);
    }

    private boolean canDecrypt() {
        return this.usages.get(4) ? !this.usages.get(7) : true;
    }

    private boolean canEncrypt() {
        return this.usages.get(4) ? !this.usages.get(8) : true;
    }

    public boolean canEncryptData() {
        return this.usages.get(3) && this.canEncrypt();
    }

    public boolean canDecryptData() {
        return this.usages.get(3) && this.canDecrypt();
    }

    public boolean canWrapKey() {
        return this.usages.get(2);
    }

    public boolean canUnwrapKey() {
        return this.usages.get(2);
    }

    public void sepparate(String txt) {
        if (txt.length() > 0) {
            txt = String.valueOf(txt) + ", ";
        }
    }

    public String getUsagesString() {
        String usages = "";
        usages = String.valueOf(usages) + (this.canSignCert() ? "Cert Signing" : "");
        this.sepparate(usages);
        usages = String.valueOf(usages) + (this.canSignCriticalData() ? "Critical Data Signing" : "");
        this.sepparate(usages);
        usages = String.valueOf(usages) + (this.canSignData() ? "Data Signing" : "");
        this.sepparate(usages);
        usages = String.valueOf(usages) + (this.canUnwrapKey() && this.canWrapKey() ? "Key Encipherment" : "");
        usages = String.valueOf(usages) + (this.canDecryptData() && this.canEncryptData() ? "Data Encipherment" : "");
        this.sepparate(usages);
        return usages;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        BIT_STRING bs = new BIT_STRING(this.usages, 9);
        bs.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ KeyUsages(BIT_STRING bIT_STRING, KeyUsages keyUsages) {
        this(bIT_STRING);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            BIT_STRING value = (BIT_STRING)BIT_STRING.getTemplate().decode(implicitTag, istream);
            return new KeyUsages(value, null);
        }
    }
}

