/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.OCSP;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.x.XResponseData;

public class BasicOCSPResponse
implements ASN1Value {
    public static String OID = OIDs.ocspBASIC;
    private XResponseData tbsRes;
    private AlgorithmIdentifier algoID;
    private BIT_STRING signature;
    private SEQUENCE certs = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;

    private BasicOCSPResponse() {
    }

    public BasicOCSPResponse(XResponseData tbsRes, AlgorithmProfile algo, byte[] signature, Certificate[] certs) {
        this.tbsRes = tbsRes;
        this.algoID = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(algo.getOID()));
        this.signature = new BIT_STRING(signature, 0);
        int i = 0;
        while (i < certs.length) {
            this.certs.addElement((ASN1Value)certs[i]);
            ++i;
        }
    }

    BasicOCSPResponse(XResponseData tbsRes, AlgorithmIdentifier algo, BIT_STRING signature, SEQUENCE certs) {
        this.tbsRes = tbsRes;
        this.algoID = algo;
        this.signature = signature;
        this.certs = certs;
    }

    public byte[] getSignature() {
        return this.signature.getBits();
    }

    public XResponseData getReponseData() {
        return this.tbsRes;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.tbsRes);
        seq.addElement((ASN1Value)this.algoID);
        seq.addElement((ASN1Value)this.signature);
        if (this.certs.size() > 0) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.certs));
        }
        seq.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return new Template();
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement((ASN1Template)new XResponseData.Template());
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)BIT_STRING.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)Certificate.getTemplate())));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            SEQUENCE sq = null;
            if (seq.elementAt(3) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(3);
                sq = (SEQUENCE)exp.getContent();
            }
            return new BasicOCSPResponse((XResponseData)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (BIT_STRING)seq.elementAt(2), sq);
        }
    }
}

