/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.OCSP;

import java.io.IOException;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.DestinationDefineFailException;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.X500.DName;
import th.co.oga.security.pki.x.OCSP.OCSPRequest;
import th.co.oga.security.pki.x.OCSP.OCSPRequestFailException;
import th.co.oga.security.pki.x.OCSP.OCSPResponse;
import th.co.oga.security.pki.x.OCSP.OCSPVerifyFailException;
import th.co.oga.security.pki.x.OnlineRequestFailException;
import th.co.oga.security.pki.x.OnlineResponseFailException;
import th.co.oga.security.pki.x.OnlineTransportFailException;
import th.co.oga.security.pki.x.PKITrnsPackage;
import th.co.oga.security.pki.x.PKIXSecureOperator;
import th.co.oga.security.pki.x.PKIXTransportFailException;
import th.co.oga.security.pki.x.XCertID;
import th.co.oga.security.pki.x.XRequest;
import th.co.oga.security.pki.x.XSignature;
import th.co.oga.security.pki.x.XTBSRequest;

public class OCSPOperator
extends PKIXSecureOperator {
    public static ServiceName SERVICE = ServiceName.OCSP;
    private TrustedPolicyTaker policyTaker;

    public OCSPOperator(Room room) throws AlgorithmSupportException, EntryNotFoundException {
        super(room);
        this.policyTaker = room.getTrustedPolicyTaker();
    }

    public static OCSPOperator getInstance(Room room) throws AlgorithmSupportException, EntryNotFoundException {
        return new OCSPOperator(room);
    }

    public OCSPRequest createRequest(CertProfile reqCer) throws OCSPRequestFailException {
        try {
            XCertID certId = this.getCertID(reqCer);
            XRequest req = new XRequest(certId);
            DName name = DName.getInstance(this.getAgentCertificate().getX509Cert().getSubjectX500Principal());
            XTBSRequest tbsReq = new XTBSRequest(name, req);
            XSignature signature = this.sign(tbsReq);
            return new OCSPRequest(tbsReq);
        }
        catch (Exception e) {
            throw new OCSPRequestFailException("create", e.toString());
        }
    }

    public void addCertificate(OCSPRequest ocspRequest, CertProfile userCer) throws OCSPRequestFailException {
        try {
            XCertID certId = this.getCertID(userCer);
            XRequest req = new XRequest(certId);
            ocspRequest.getTBSRequest().addRequest(req);
        }
        catch (Exception e) {
            throw new OCSPRequestFailException("add cert entry", e);
        }
    }

    public void verify(CertProfile userCer) throws OCSPRequestFailException, PKIXTransportFailException, DestinationDefineFailException, OCSPVerifyFailException {
        try {
            OCSPRequest req = this.createRequest(userCer);
            AuthorityService dest = this.policyTaker.getOCSPAuthorityService(userCer);
            OCSPResponse res = this.sendRequest(req, dest);
            if (!res.getStatus()) {
                throw new OCSPVerifyFailException("Certificate invalid," + res.getStatusText());
            }
        }
        catch (ASN1Exception e) {
            throw new DestinationDefineFailException(e.getMessage());
        }
    }

    public OCSPResponse sendRequest(OCSPRequest req, AuthorityService dest) throws OnlineRequestFailException, OnlineResponseFailException, OnlineTransportFailException {
        try {
            PKITrnsPackage trnsPkg = this.transfer(req, dest);
            return (OCSPResponse)trnsPkg.getResponsePackage();
        }
        catch (IOException e) {
            throw new OnlineResponseFailException(" System error IO Exception " + e.getMessage());
        }
    }
}

