/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.OCSP;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;
import th.co.oga.security.pki.x.OCSP.OCSPReqHeader;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;
import th.co.oga.security.pki.x.XSignature;
import th.co.oga.security.pki.x.XTBSRequest;
import th.co.oga.security.utils.Base64OutputStream;

public class OCSPRequest
implements ASN1Value,
PKIDataPackage {
    private XTBSRequest tbsReq;
    private XSignature signature;
    private boolean verify;
    private PKITrnsHeader header = new OCSPReqHeader();
    public static final Tag TAG = SEQUENCE.TAG;

    private OCSPRequest() {
    }

    public OCSPRequest(XTBSRequest tbsRequest) {
        this(tbsRequest, null);
    }

    public OCSPRequest(XTBSRequest tbsRequest, XSignature signature) {
        this.tbsReq = tbsRequest;
        this.signature = signature;
    }

    public XSignature getSignature() {
        return this.signature;
    }

    public XTBSRequest getTBSRequest() {
        return this.tbsReq;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public void setSignature(XSignature signature) {
        this.signature = signature;
    }

    public void setTBSRequest(XTBSRequest req) {
        this.tbsReq = req;
    }

    public void setVerify(boolean flag) {
        this.verify = flag;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.tbsReq);
        if (this.signature != null) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.signature));
        }
        seq.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return new Template();
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        try {
            OCSPRequest req = (OCSPRequest)OCSPRequest.getTemplate().decode(in);
            this.setTBSRequest(req.getTBSRequest());
            this.setSignature(req.getSignature());
        }
        catch (InvalidBERException e) {
            throw new TransportPackageEncodingFailException((Exception)((Object)e));
        }
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        if (format.equals(TransportEncodeFormat.PEM)) {
            PrintStream printer = new PrintStream(out);
            Base64OutputStream b64Out = new Base64OutputStream(printer, 16);
            this.encode(b64Out);
        } else {
            this.encode(out);
        }
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader header) {
        this.header.set(header);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement((ASN1Template)new XTBSRequest.Template());
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)new XSignature.Template()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            XSignature sgn = null;
            if (seq.elementAt(1) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(1);
                sgn = (XSignature)exp.getContent();
            }
            return new OCSPRequest((XTBSRequest)seq.elementAt(0), sgn);
        }
    }
}

