/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.OCSP;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;
import th.co.oga.security.pki.x.OCSP.BasicOCSPResponse;
import th.co.oga.security.pki.x.OCSP.OCSPResHeader;
import th.co.oga.security.pki.x.OCSP.OCSPResponseStatus;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;
import th.co.oga.security.pki.x.XResponseBytes;
import th.co.oga.security.utils.Base64InputStream;
import th.co.oga.security.utils.Base64OutputStream;

public class OCSPResponse
implements ASN1Value,
PKIDataPackage {
    public static String BASIC_OCSP_RESPONSE_OID = OIDs.ocspBASIC;
    private OCSPResponseStatus status;
    private XResponseBytes response;
    private PKITrnsHeader header = new OCSPResHeader();
    public static final Tag TAG = SEQUENCE.TAG;

    public OCSPResponse() {
    }

    OCSPResponse(OCSPResponseStatus status, XResponseBytes response) {
        this.status = status;
        this.response = response;
    }

    public void setResponseStatus(OCSPResponseStatus status) {
        this.status = status;
    }

    public void setResponseBytes(XResponseBytes response) {
        this.response = response;
    }

    public OCSPResponseStatus getResponseStatus() {
        return this.status;
    }

    public boolean getStatus() {
        return this.status.getStatus();
    }

    public String getStatusText() {
        return this.status.getStatusText();
    }

    public XResponseBytes getResponseBytes() {
        return this.response;
    }

    public ASN1Value getResponseContent() throws InvalidBERException, IOException {
        String oid = this.response.getOID();
        ByteArrayInputStream in = new ByteArrayInputStream(this.response.getContent());
        if (oid.equals(BasicOCSPResponse.OID)) {
            return BasicOCSPResponse.getTemplate().decode(in);
        }
        throw new IllegalArgumentException("The response content type is unknow,oid#" + oid);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.status);
        if (this.response != null) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.response));
        }
        seq.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return new Template();
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        try {
            OCSPResponse res;
            if (format.equals(TransportEncodeFormat.PEM)) {
                Base64InputStream b64In = new Base64InputStream(in);
                res = (OCSPResponse)OCSPResponse.getTemplate().decode(b64In);
            } else {
                res = (OCSPResponse)OCSPResponse.getTemplate().decode(in);
            }
            this.setResponseBytes(res.getResponseBytes());
            this.setResponseStatus(res.getResponseStatus());
        }
        catch (InvalidBERException e) {
            throw new TransportPackageEncodingFailException((Exception)((Object)e));
        }
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        if (format.equals(TransportEncodeFormat.PEM)) {
            PrintStream printer = new PrintStream(out);
            Base64OutputStream b64Out = new Base64OutputStream(printer, 16);
            this.encode(b64Out);
        } else {
            this.encode(out);
        }
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader header) {
        this.header.set(header);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement((ASN1Template)new OCSPResponseStatus.Template());
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)new XResponseBytes.Template()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            XResponseBytes res = null;
            if (seq.elementAt(1) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(1);
                res = (XResponseBytes)exp.getContent();
            }
            return new OCSPResponse((OCSPResponseStatus)seq.elementAt(0), res);
        }
    }
}

