/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.OCSP;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class OCSPResponseStatus
implements ASN1Value {
    public static int successful = 0;
    public static int malformedRequest = 1;
    public static int internalError = 2;
    public static int tryLater = 3;
    public static int sigRequired = 5;
    public static int unauthorized = 6;
    public static ENUMERATED[] status = new ENUMERATED[]{new ENUMERATED(0L), new ENUMERATED(1L), new ENUMERATED(2L), new ENUMERATED(3L), new ENUMERATED(5L), new ENUMERATED(6L)};
    private String[] reasonTexts;
    private ENUMERATED statusCode;
    public static final Tag TAG = ENUMERATED.TAG;
    private static final Template TEMPLATE = new Template();

    protected OCSPResponseStatus(ENUMERATED reasonCode) {
        String[] stringArray = new String[7];
        stringArray[0] = "successful";
        stringArray[1] = "Malformed Request";
        stringArray[2] = "Internal Error";
        stringArray[3] = "Try Later";
        stringArray[5] = "Signature Required";
        stringArray[6] = "Unauthorized";
        this.reasonTexts = stringArray;
        this.statusCode = reasonCode;
    }

    public OCSPResponseStatus(int reasonCode) {
        String[] stringArray = new String[7];
        stringArray[0] = "successful";
        stringArray[1] = "Malformed Request";
        stringArray[2] = "Internal Error";
        stringArray[3] = "Try Later";
        stringArray[5] = "Signature Required";
        stringArray[6] = "Unauthorized";
        this.reasonTexts = stringArray;
        this.statusCode = status[reasonCode];
    }

    public String getStatusText() {
        return this.reasonTexts[this.statusCode.intValue()];
    }

    public boolean getStatus() {
        return this.statusCode.intValue() == 0;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.statusCode.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt;

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            ENUMERATED enu = (ENUMERATED)ENUMERATED.getTemplate().decode(implicit, istream);
            return new OCSPResponseStatus(enu);
        }
    }
}

