/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class PKIFailureInfo
implements ASN1Value {
    public static int BAD_ALGO = 0;
    public static int INTEGRITY_CHECK_FAIL = 1;
    public static int BAD_REQUEST = 2;
    public static int BAD_TIME = 3;
    public static int BAD_CERT_ID = 4;
    public static int BAD_DATA_FORMAT = 5;
    public static int WRONG_AUTHORITY = 6;
    public static int INCORRECT_DATA = 7;
    public static int MISSING_TIMESTAMP = 8;
    public static int BAD_POP = 9;
    public static String[] reasonText = new String[]{"unrecognized or unsupported Algorithm Identifier", "integrity check failed (e.g., signature did not verify)", "transaction not permitted or supported", "messageTime was not sufficiently close to the system time, as defined by local policy", "no certificate could be found matching the provided criteria", "the data submitted has the wrong format", "the authority indicated in the request is different from the one creating the response token", "the requester's data is incorrect (used for notary services)", "when the timestamp is missing but should be there (by policy)", "the proof-of-possession failed"};
    public static String[] reasonID = new String[]{"BadAlgo", "unIntegrity", "BadRequest", "BadTime", "BadCertId", "BadDataFormat", "WrongAuthority", "IncorrectData", "MissingTimestamp", "BadPOP"};
    private BIT_STRING reasons;
    public static Tag TAG = BIT_STRING.TAG;
    private static final Template TEMPLATE = new Template();

    private PKIFailureInfo(BIT_STRING bs) {
        this.reasons = bs;
    }

    public PKIFailureInfo() {
        this.reasons = new BIT_STRING(new BitSet(10), 7);
    }

    public String getReasonText() {
        boolean[] bools = this.reasons.toBooleanArray();
        String msg = "";
        int i = 0;
        while (i < bools.length) {
            if (bools[i]) {
                if (msg.length() > 0) {
                    msg = String.valueOf(msg) + ", ";
                }
                msg = String.valueOf(msg) + reasonText[i];
            }
            ++i;
        }
        return msg;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.reasons.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ PKIFailureInfo(BIT_STRING bIT_STRING, PKIFailureInfo pKIFailureInfo) {
        this(bIT_STRING);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            BIT_STRING value = (BIT_STRING)BIT_STRING.getTemplate().decode(implicitTag, istream);
            return new PKIFailureInfo(value, null);
        }
    }
}

