/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;

public class PKIFreeText
implements ASN1Value {
    private SEQUENCE ts;
    public static final Tag TAG = SEQUENCE.TAG;

    private PKIFreeText() {
    }

    public PKIFreeText(String text) throws CharConversionException {
        this.ts = new SEQUENCE();
        this.ts.addElement((ASN1Value)new UTF8String(text));
    }

    PKIFreeText(SEQUENCE seq) {
        this.ts = seq;
    }

    public UTF8String at(int idx) {
        return (UTF8String)this.ts.elementAt(idx);
    }

    public int size() {
        return this.ts.size();
    }

    public String getData() {
        StringWriter str = new StringWriter();
        int i = 0;
        while (i < this.size()) {
            if (i > 0) {
                str.write(", ");
            }
            str.write(this.at(i).toString());
            ++i;
        }
        return str.toString();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.ts.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.ts.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.OF_Template seqq = new SEQUENCE.OF_Template((ASN1Template)UTF8String.getTemplate());
            SEQUENCE seq = (SEQUENCE)seqq.decode(implicit, istream);
            if (seq.size() < 1) {
                throw new InvalidBERException("FreeText with zero elements, an FreeText must have at least one element");
            }
            return new PKIFreeText(seq);
        }
    }
}

