/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.x.PKIFailureInfo;
import th.co.oga.security.pki.x.PKIFreeText;

public class PKIStatusInfo
implements ASN1Value {
    public static int GRANTED = 0;
    public static int GRANTED_WTIH_MODS = 1;
    public static int REJECTION = 2;
    public static int WAITING = 3;
    public static int REVOCATION_WARNING = 4;
    public static int REVOCATION_NOTIFICATION = 5;
    private INTEGER pkiStatus;
    private PKIFailureInfo failInfo;
    private PKIFreeText freeText;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected PKIStatusInfo(int status) throws InvalidBERException {
        this.pkiStatus = new INTEGER((long)status);
    }

    private PKIStatusInfo(INTEGER status, PKIFreeText text, PKIFailureInfo failure) throws InvalidBERException {
        this.pkiStatus = status;
        this.failInfo = failure;
        this.freeText = text;
    }

    public boolean getHealtyStatus() {
        int status = this.pkiStatus.intValue();
        return status == 0 || status == 1 || status == 4;
    }

    public String getStatusMessage() {
        int status = this.pkiStatus.intValue();
        if (status == 0) {
            return "TimeStampToken was returned ";
        }
        if (status == 1) {
            return "TimeStampToken was returned with modifications ";
        }
        if (status == 2) {
            return "The request was rejected";
        }
        if (status == 3) {
            return "Waiting";
        }
        if (status == 4) {
            return "Warning that a revocation is imminent";
        }
        if (status == 5) {
            return "Notification that a revocation has occured";
        }
        return "The message have not avariable for #" + status;
    }

    public String getFailReason() {
        if (this.failInfo != null) {
            return this.failInfo.getReasonText();
        }
        return null;
    }

    public String getFreeText() {
        if (this.freeText != null) {
            return this.freeText.getData();
        }
        return "";
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.pkiStatus);
        if (this.freeText != null) {
            seq.addElement((ASN1Value)this.freeText);
        }
        if (this.failInfo != null) {
            seq.addElement((ASN1Value)this.failInfo);
        }
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ PKIStatusInfo(INTEGER iNTEGER, PKIFreeText pKIFreeText, PKIFailureInfo pKIFailureInfo, PKIStatusInfo pKIStatusInfo) throws InvalidBERException {
        this(iNTEGER, pKIFreeText, pKIFailureInfo);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new PKIFreeText.Template());
            this.seqt.addOptionalElement((ASN1Template)PKIFailureInfo.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            PKIFreeText text = null;
            if (seq.elementAt(1) != null) {
                text = (PKIFreeText)seq.elementAt(1);
            }
            PKIFailureInfo fails = null;
            if (seq.elementAt(2) != null) {
                fails = (PKIFailureInfo)seq.elementAt(2);
            }
            return new PKIStatusInfo((INTEGER)seq.elementAt(0), text, fails, null);
        }
    }
}

