/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.RoomForService;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Transport.MimeTypeNotSupportException;
import th.co.oga.security.pki.Transport.TransportConnector;
import th.co.oga.security.pki.Transport.TransportMimeType;
import th.co.oga.security.pki.Transport.TransportMonitor;
import th.co.oga.security.pki.Transport.TransportPackageLoadingException;
import th.co.oga.security.pki.Transport.TransportProtocol;
import th.co.oga.security.pki.Transport.UnAccaptableDataPackageException;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.DestinationDefineFailException;
import th.co.oga.security.pki.Trusted.NoAuthorityToServeException;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.x.CSR.CertDeliveryPackage;
import th.co.oga.security.pki.x.OCSP.OCSPResponse;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;
import th.co.oga.security.pki.x.PKITrnsPackage;
import th.co.oga.security.pki.x.PKITrnsProtocol;
import th.co.oga.security.pki.x.Timestamp.TimestampResponseInfo;

public class PKITrnsOperator {
    private TrustedPolicyTaker policyTaker;
    private TransportMonitor tMon;
    private PKITrnsPackage trnsPkg;
    private boolean traceMode = false;
    private PKITrnsProtocol pkiProtocol;
    private ServiceName service;

    private PKITrnsOperator(TrustedPolicyTaker policyTaker) {
        this.policyTaker = policyTaker;
    }

    public void setRequest(PKIDataPackage req) throws MimeTypeNotSupportException {
        PKITrnsHeader rhdr = req.getHeader();
        this.pkiProtocol = rhdr.getPKIProtocol();
        this.service = rhdr.getService();
        TransportMimeType pkgMime = rhdr.getPkgMimeType();
        if (pkgMime.equals(TransportMimeType.TIMESTAMP_SIGNING_REQUEST)) {
            this.trnsPkg = new PKITrnsPackage(req, new TimestampResponseInfo());
        } else if (pkgMime.equals(TransportMimeType.CRL)) {
            this.trnsPkg = new PKITrnsPackage(req, req);
        } else if (pkgMime.equals(TransportMimeType.MUTIPART_FORM)) {
            this.trnsPkg = new PKITrnsPackage(req, req);
        } else if (TransportMimeType.CSR.equals(pkgMime)) {
            this.trnsPkg = new PKITrnsPackage(req, new CertDeliveryPackage());
        } else if (TransportMimeType.OCSP_REQUEST.equals(pkgMime)) {
            this.trnsPkg = new PKITrnsPackage(req, new OCSPResponse());
        } else {
            throw new MimeTypeNotSupportException("PKITrnsOperator", "There are no service taker support " + pkgMime);
        }
    }

    public static PKITrnsOperator getInstance(Room room) {
        return new PKITrnsOperator(room.getTrustedPolicyTaker());
    }

    public static PKITrnsOperator getInstance(RoomForService room) {
        return new PKITrnsOperator(room.getTrustedPolicyTaker());
    }

    public static PKITrnsOperator getInstance(TrustedPolicyTaker policyTaker) {
        return new PKITrnsOperator(policyTaker);
    }

    public PKITrnsPackage getPKITrnsPkg() {
        return this.trnsPkg;
    }

    public void transfer() throws UnAccaptableDataPackageException, IOException, DestinationDefineFailException, MalformedURLException, UnSupportProtocolException, ASN1Exception, TransportPackageLoadingException {
        Object destination = null;
        Authority auth = this.policyTaker.getTrustedAuthority(this.service);
        if (auth == null) {
            throw new NoAuthorityToServeException("There aro no any authority in register serve the " + this.service.getName());
        }
        this.transfer(auth.getService(this.service));
    }

    public void transfer(AuthorityService dest) throws UnAccaptableDataPackageException, MalformedURLException, IOException, UnSupportProtocolException, ASN1Exception, TransportPackageLoadingException {
        PasswordAuthentication authen = dest.getAuthen();
        TransportConnector connector = TransportProtocol.getConnector(dest);
        connector.setTraceMode(this.traceMode);
        if (dest.getRecipient() != null) {
            connector.addRecipient(dest.getRecipient());
        }
        if (dest.getSender() != null) {
            connector.setSender(dest.getSender());
        }
        connector.setContentType(this.trnsPkg.getContentType());
        if (this.pkiProtocol.is(PKITrnsProtocol.CMP)) {
            connector.multipartRequest(this.trnsPkg, this.trnsPkg);
        } else {
            connector.inLineRequest(this.trnsPkg, this.trnsPkg);
        }
        connector.close();
    }

    public TransportMonitor getMonitor() {
        return this.tMon;
    }
}

