/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackage;
import th.co.oga.security.pki.x.PKIDataPackage;

public class PKITrnsPackage
implements TransportPackage {
    private PKIDataPackage req;
    private PKIDataPackage res;
    private TransportEncodeFormat format = TransportEncodeFormat.DER;
    private ByteArrayOutputStream outBuff = new ByteArrayOutputStream();
    private ByteArrayOutputStream inBuff = new ByteArrayOutputStream();

    public PKITrnsPackage(PKIDataPackage req, PKIDataPackage res) {
        this.req = req;
        this.res = res;
    }

    public void setPKIEncodeFormat(TransportEncodeFormat format) {
        this.format = format;
    }

    public Object getResponsePackage() throws IOException {
        this.flush();
        return this.res;
    }

    public void flush() throws IOException {
        if (this.inBuff.size() > 0) {
            this.res.decode(new ByteArrayInputStream(this.inBuff.toByteArray()), this.format);
            this.inBuff.reset();
        }
    }

    public void decode(InputStream in) throws IOException {
        this.res.decode(in, this.format);
    }

    public void encode(OutputStream out) throws IOException {
        this.req.encode(out, this.format);
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        this.res.decode(in, format);
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        this.req.encode(out, format);
    }

    public TransportHeader getHeader() {
        return this.req.getHeader();
    }

    public void setHeader(TransportHeader header) {
        this.res.setTrnsHeader(header);
    }

    public String getContentType() {
        return this.req.getHeader().getPkgMimeType().getMimeType();
    }

    public String getName() {
        return this.req.getHeader().getName();
    }

    public InputStream getInputStream() throws IOException {
        this.req.encode(this.outBuff, this.format);
        ByteArrayInputStream in = new ByteArrayInputStream(this.outBuff.toByteArray());
        this.outBuff.reset();
        return in;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.inBuff;
    }
}

