/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.CryptoPolicyTaker;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.CryptoOperatorException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.Transport.MimeTypeNotSupportException;
import th.co.oga.security.pki.Transport.UnAccaptableDataPackageException;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.x.OCSP.OCSPRequest;
import th.co.oga.security.pki.x.OnlineRequestFailException;
import th.co.oga.security.pki.x.OnlineTransportFailException;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsOperator;
import th.co.oga.security.pki.x.PKITrnsPackage;
import th.co.oga.security.pki.x.XCertID;
import th.co.oga.security.pki.x.XSignature;
import th.co.oga.security.pki.x.XTBSRequest;

public class PKIXSecureOperator {
    private SecureOperator oper;
    private Room room;
    private CryptoPolicyTaker cTaker;
    private PKITrnsOperator trnOper;

    public PKIXSecureOperator(Room room) throws AlgorithmSupportException {
        this.cTaker = room.getCryptoPolicyTaker();
        this.oper = room.getSecureOperator();
        this.trnOper = PKITrnsOperator.getInstance(room);
        this.room = room;
    }

    public CertProfile getAgentCertificate() throws EntryNotFoundException {
        try {
            return this.room.getFirstCertificate();
        }
        catch (SecureStoreException e) {
            throw new EntryNotFoundException("Agent's certificate is not found," + e.getMessage());
        }
    }

    public void sign(OCSPRequest request) throws IOException, CryptoOperatorException, SignatureException, EntryNotFoundException {
        AlgorithmProfile signingAlgo = this.cTaker.getSigningAlgo();
        byte[] tbsData = ASN1Util.encode((ASN1Value)request.getTBSRequest());
        CertProfile agentCert = this.getAgentCertificate();
        Signature signer = this.oper.getSigner(agentCert, signingAlgo);
        signer.update(tbsData);
        XSignature xSignature = new XSignature(signingAlgo, signer.sign(), agentCert);
        request.setSignature(xSignature);
    }

    public boolean verify(OCSPRequest request) throws IOException, CryptoOperatorException, AlgorithmSupportException, SignatureException, CertificateException, ASN1Exception {
        XSignature xsignature = request.getSignature();
        if (xsignature != null) {
            AlgorithmProfile signingAlgo = this.cTaker.signingAlgoSet.findByOID(xsignature.getAlgoOID());
            CertProfile signCert = xsignature.getSignCertificate();
            byte[] tbsData = ASN1Util.encode((ASN1Value)request.getTBSRequest());
            Signature verifier = this.oper.getVerifier(signCert, signingAlgo);
            verifier.update(tbsData);
            try {
                return verifier.verify(xsignature.getSignature());
            }
            catch (SignatureException e) {
                return false;
            }
        }
        return false;
    }

    public XCertID getCertID(CertProfile userCer) throws AlgorithmSupportException, EntryNotFoundException, CertProfileException, IOException, CertificateException, NoSuchAlgorithmException {
        AlgorithmProfile hashAlgo = this.cTaker.getMessageDigestAlgo();
        CertProfile issuerCer = this.oper.getStoreOperator().getIssuerCertificate(userCer);
        byte[] issuerName = issuerCer.getX509Cert().getSubjectX500Principal().getEncoded();
        byte[] issuerKey = issuerCer.getX509Cert().getPublicKey().getEncoded();
        MessageDigest md = this.oper.getCryptoOperator().getMessageDigest(hashAlgo);
        byte[] nameHash = md.digest(issuerName);
        byte[] keyHash = md.digest(issuerKey);
        return new XCertID(hashAlgo, nameHash, keyHash, userCer.getX509Cert().getSerialNumber().toString());
    }

    public XSignature sign(XTBSRequest req) throws IOException, AlgorithmSupportException, SecureStoreFindingFailException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, EntryNotFoundException {
        byte[] tbsData = ASN1Util.encode((ASN1Value)req);
        byte[] signature = this.oper.signData(tbsData, this.cTaker.getSigningAlgo(), this.getAgentCertificate());
        return new XSignature(this.cTaker.getSigningAlgo(), signature, this.getAgentCertificate());
    }

    public PKITrnsPackage transfer(PKIDataPackage req, AuthorityService dest) throws OnlineRequestFailException, OnlineTransportFailException {
        try {
            this.trnOper.setRequest(req);
            this.trnOper.transfer(dest);
            return this.trnOper.getPKITrnsPkg();
        }
        catch (MimeTypeNotSupportException e) {
            throw new OnlineRequestFailException(e.getMessage());
        }
        catch (UnSupportProtocolException e) {
            throw new OnlineRequestFailException(e.getMessage());
        }
        catch (UnAccaptableDataPackageException e) {
            throw new OnlineRequestFailException(e.getMessage());
        }
        catch (ASN1Exception e) {
            throw new OnlineTransportFailException(e.getMessage());
        }
        catch (IOException e) {
            throw new OnlineTransportFailException(" System error IO Exception " + e.getMessage());
        }
    }
}

