/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.Timestamp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class Accuracy
implements ASN1Value {
    private INTEGER seconds;
    private INTEGER millis;
    private INTEGER micros;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    public Accuracy(BigInteger s, BigInteger ml, BigInteger mc) throws InvalidBERException {
        this.seconds = new INTEGER(s);
        this.millis = new INTEGER(ml);
        this.micros = new INTEGER(mc);
    }

    private Accuracy(INTEGER s, INTEGER ml, INTEGER mc) throws InvalidBERException {
        this.seconds = s;
        this.millis = ml;
        this.micros = mc;
    }

    public BigInteger getSeconds() throws InvalidBERException {
        return this.seconds.abs();
    }

    public BigInteger getMillis() throws InvalidBERException {
        return this.millis.abs();
    }

    public BigInteger getMicros() throws InvalidBERException {
        return this.micros.abs();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.seconds);
        seq.addElement((ASN1Value)this.millis);
        seq.addElement((ASN1Value)this.micros);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ Accuracy(INTEGER iNTEGER, INTEGER iNTEGER2, INTEGER iNTEGER3, Accuracy accuracy) throws InvalidBERException {
        this(iNTEGER, iNTEGER2, iNTEGER3);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), INTEGER.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            INTEGER s = null;
            INTEGER ml = null;
            INTEGER mc = null;
            if (seq.elementAt(0) != null) {
                s = (INTEGER)seq.elementAt(0);
            }
            if (seq.elementAt(1) != null) {
                ml = (INTEGER)seq.elementAt(1);
            }
            if (seq.elementAt(2) != null) {
                mc = (INTEGER)seq.elementAt(2);
            }
            return new Accuracy(s, ml, mc, null);
        }
    }
}

