/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.Timestamp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.OIDs;

public class MessageImprint
implements ASN1Value {
    private AlgorithmIdentifier hashAlgo;
    private OCTET_STRING hashMsg;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    public MessageImprint(AlgorithmProfile alg, byte[] digest) throws InvalidBERException {
        this(alg.getOID(), digest);
    }

    public MessageImprint(String oid, byte[] digest) throws InvalidBERException {
        this(new AlgorithmIdentifier(new OBJECT_IDENTIFIER(oid)), new OCTET_STRING(digest));
    }

    private MessageImprint(AlgorithmIdentifier oid, OCTET_STRING hashMsg) throws InvalidBERException {
        this.hashAlgo = oid;
        this.hashMsg = hashMsg;
    }

    public byte[] getDigest() throws InvalidBERException {
        return this.hashMsg.toByteArray();
    }

    public String getOID() {
        return OIDs.fromLongs(this.hashAlgo.getOID().getNumbers());
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.hashAlgo);
        seq.addElement((ASN1Value)this.hashMsg);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ MessageImprint(AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING, MessageImprint messageImprint) throws InvalidBERException {
        this(algorithmIdentifier, oCTET_STRING);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new MessageImprint((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1), null);
        }
    }
}

