/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.Timestamp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Calendar;
import org.mozilla.jss.asn1.InvalidBERException;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.Packaging.RawDigestInfo;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.DestinationDefineFailException;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.x.OnlineRequestFailException;
import th.co.oga.security.pki.x.OnlineResponseFailException;
import th.co.oga.security.pki.x.OnlineTransportFailException;
import th.co.oga.security.pki.x.PKITrnsPackage;
import th.co.oga.security.pki.x.PKIXSecureOperator;
import th.co.oga.security.pki.x.Timestamp.TimestampRequestInfo;
import th.co.oga.security.pki.x.Timestamp.TimestampResponseInfo;

public class TimestampOperator
extends PKIXSecureOperator {
    private SecureOperator oper;
    private TrustedPolicyTaker policyTaker;
    public static ServiceName SERVICE = ServiceName.TIMESTAMP;

    public TimestampOperator(Room room) throws AlgorithmSupportException, EntryNotFoundException {
        super(room);
        this.oper = room.getSecureOperator();
        this.policyTaker = room.getTrustedPolicyTaker();
    }

    protected BigInteger genNonce() throws NoSuchAlgorithmException {
        SecureRandom rand = this.oper.getCryptoOperator().getSecureRandom();
        byte[] serialBytes = new byte[8];
        byte[] seed = BigInteger.valueOf(Calendar.getInstance().getTimeInMillis()).toByteArray();
        rand.setSeed(seed);
        rand.nextBytes(serialBytes);
        return new BigInteger(1, serialBytes);
    }

    public TimestampRequestInfo genTSR(RawDigestInfo digestInfo) throws ASN1Exception, NoSuchAlgorithmException {
        byte[] digest = digestInfo.getDigest();
        AlgorithmProfile digestAlg = digestInfo.getAlgorithm();
        BigInteger nonce = this.genNonce();
        try {
            return new TimestampRequestInfo(digest, digestAlg, nonce, true);
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception((Exception)((Object)e));
        }
    }

    public TimestampRequestInfo getTSR(byte[] rawData, AlgorithmProfile digestAlg) throws ASN1Exception, NoSuchAlgorithmException {
        MessageDigest md = this.oper.getCryptoOperator().getMessageDigest(digestAlg);
        byte[] digest = md.digest(rawData);
        return this.genTSR(new RawDigestInfo(digest, digestAlg));
    }

    public TimestampResponseInfo sign(byte[] digest, AlgorithmProfile digestAlgo) throws OnlineRequestFailException, OnlineResponseFailException, OnlineTransportFailException {
        try {
            AuthorityService dest = this.policyTaker.getService(null, SERVICE);
            BigInteger nonce = this.genNonce();
            TimestampRequestInfo reqInfo = new TimestampRequestInfo(digest, digestAlgo, nonce, true);
            PKITrnsPackage trnsPkg = this.transfer(reqInfo, dest);
            return (TimestampResponseInfo)trnsPkg.getResponsePackage();
        }
        catch (DestinationDefineFailException e) {
            throw new OnlineRequestFailException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new OnlineRequestFailException(e.getMessage());
        }
        catch (InvalidBERException e) {
            throw new OnlineRequestFailException(e.getMessage());
        }
        catch (IOException e) {
            throw new OnlineResponseFailException(" System error IO Exception " + e.getMessage());
        }
    }
}

