/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.Timestamp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsHeader;
import th.co.oga.security.pki.x.Timestamp.MessageImprint;
import th.co.oga.security.pki.x.Timestamp.TSQTrnsHeader;
import th.co.oga.security.utils.Base64OutputStream;

public class TimestampRequestInfo
implements ASN1Value,
PKIDataPackage {
    public static final INTEGER VERSION = new INTEGER(1L);
    private INTEGER version;
    private MessageImprint msgImprint;
    private OBJECT_IDENTIFIER reqPolicy;
    private INTEGER nonce;
    private BOOLEAN certReq;
    private SEQUENCE exts;
    private PKITrnsHeader header = new TSQTrnsHeader();
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    public TimestampRequestInfo(String oid, byte[] digest, AlgorithmProfile digestAlgo, BigInteger nonce, boolean reqTimestampCert) throws InvalidBERException {
        this(oid, digest, digestAlgo, nonce, reqTimestampCert, null);
    }

    public TimestampRequestInfo(byte[] digest, AlgorithmProfile digestAlgo, BigInteger nonce, boolean reqTimestampCert) throws InvalidBERException {
        this(null, digest, digestAlgo, nonce, reqTimestampCert, null);
    }

    public TimestampRequestInfo(String oid, byte[] digest, AlgorithmProfile digestAlgo, BigInteger nonce, boolean reqTimestampCert, SEQUENCE certificateExtensions) throws InvalidBERException {
        this.version = VERSION;
        if (oid != null) {
            this.reqPolicy = new OBJECT_IDENTIFIER(oid);
        }
        this.msgImprint = new MessageImprint(digestAlgo, digest);
        this.nonce = new INTEGER(nonce);
        this.certReq = new BOOLEAN(reqTimestampCert);
        this.exts = certificateExtensions;
    }

    private TimestampRequestInfo(INTEGER v, MessageImprint mi, OBJECT_IDENTIFIER rp, INTEGER n, BOOLEAN cr, SEQUENCE exts) throws InvalidBERException {
        this.version = v;
        this.msgImprint = mi;
        this.reqPolicy = rp;
        this.nonce = n;
        this.certReq = cr;
        this.exts = exts;
    }

    public byte[] getDigest() throws InvalidBERException {
        return this.msgImprint.getDigest();
    }

    public String getDigestAlgoOID() {
        return this.msgImprint.getOID();
    }

    public BigInteger getNonce() {
        return this.nonce.abs();
    }

    public void setTSAPolicyOID(String oid) {
        this.reqPolicy = new OBJECT_IDENTIFIER(oid);
    }

    public void setCertRequest(boolean is) {
        this.certReq = new BOOLEAN(is);
    }

    public void setNonce(String tbnonce) {
        this.nonce = tbnonce != null ? new INTEGER(tbnonce) : null;
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        byte[] prefix = new byte[]{60, 60};
        byte[] suffix = new byte[]{62, 62};
        if (format.equals(TransportEncodeFormat.PEM)) {
            PrintStream printer = new PrintStream(out);
            Base64OutputStream b64Out = new Base64OutputStream(printer, 16);
            this.encode(b64Out);
        } else {
            this.encode(out);
        }
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader trnsHeader) {
        this.header.set(trnsHeader);
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.version);
        seq.addElement((ASN1Value)this.msgImprint);
        if (this.reqPolicy != null) {
            seq.addElement((ASN1Value)this.reqPolicy);
        }
        if (this.nonce != null) {
            seq.addElement((ASN1Value)this.nonce);
        }
        seq.addElement((ASN1Value)this.certReq);
        if (this.exts != null) {
            seq.addElement((ASN1Value)this.exts);
        }
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ TimestampRequestInfo(INTEGER iNTEGER, MessageImprint messageImprint, OBJECT_IDENTIFIER oBJECT_IDENTIFIER, INTEGER iNTEGER2, BOOLEAN bOOLEAN, SEQUENCE sEQUENCE, TimestampRequestInfo timestampRequestInfo) throws InvalidBERException {
        this(iNTEGER, messageImprint, oBJECT_IDENTIFIER, iNTEGER2, bOOLEAN, sEQUENCE);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)MessageImprint.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addOptionalElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)BOOLEAN.getTemplate(), (ASN1Value)new BOOLEAN(false));
            this.seqt.addOptionalElement(new Tag(0L), (ASN1Template)SEQUENCE.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            OBJECT_IDENTIFIER oid = null;
            if (seq.elementAt(2) != null) {
                oid = (OBJECT_IDENTIFIER)seq.elementAt(2);
            }
            INTEGER n = null;
            if (seq.elementAt(3) != null) {
                n = (INTEGER)seq.elementAt(3);
            }
            SEQUENCE s = null;
            if (seq.elementAt(5) != null) {
                s = (SEQUENCE)seq.elementAt(5);
            }
            return new TimestampRequestInfo((INTEGER)seq.elementAt(0), (MessageImprint)seq.elementAt(1), oid, n, (BOOLEAN)seq.elementAt(4), s, null);
        }
    }
}

