/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.Timestamp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.P7.P7ContentInfo;
import th.co.oga.security.pki.P7.P7SignedData;
import th.co.oga.security.pki.Transport.TransportEncodeFormat;
import th.co.oga.security.pki.Transport.TransportHeader;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKIStatusInfo;
import th.co.oga.security.pki.x.PKITrnsHeader;
import th.co.oga.security.pki.x.Timestamp.TSRTrnsHeader;
import th.co.oga.security.pki.x.Timestamp.TimestampTokenInfo;
import th.co.oga.security.utils.Base64InputStream;
import th.co.oga.security.utils.Base64OutputStream;

public class TimestampResponseInfo
implements ASN1Value,
PKIDataPackage {
    public static final OBJECT_IDENTIFIER TIMESTAMP_TOKEN_INFO = new OBJECT_IDENTIFIER(OIDs.PKCS9_TimestampTokenInfo);
    public static final INTEGER VERSION = new INTEGER(1L);
    private PKIStatusInfo statusInfo;
    private P7ContentInfo contentInfo;
    private PKITrnsHeader header = new TSRTrnsHeader();
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    private TimestampResponseInfo(PKIStatusInfo statusInfo, P7ContentInfo contentInfo) throws InvalidBERException {
        this.statusInfo = statusInfo;
        this.contentInfo = contentInfo;
    }

    public TimestampResponseInfo() {
    }

    public PKIStatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public boolean getStatus() {
        return this.statusInfo.getHealtyStatus();
    }

    public String getReason() {
        return this.statusInfo.getFailReason();
    }

    public String getStatusMessage() {
        String mess = this.statusInfo.getStatusMessage();
        if (this.getReason() != null) {
            mess = String.valueOf(mess) + "\r\n" + this.getReason();
        }
        return mess;
    }

    public P7ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public P7SignedData getSignedData() throws ASN1Exception {
        try {
            return (P7SignedData)this.contentInfo.getInterpretedContent();
        }
        catch (InvalidBERException e) {
            throw new ASN1Exception((Exception)((Object)e));
        }
    }

    public TimestampTokenInfo getTokenInfo() throws IOException, ASN1Exception {
        P7ContentInfo ci = this.contentInfo;
        if (ci.getContentType().equals((Object)P7ContentInfo.SIGNED_DATA)) {
            ci = this.getSignedData().getContentInfo();
        }
        if (ci.getContentType().equals((Object)TIMESTAMP_TOKEN_INFO)) {
            try {
                return (TimestampTokenInfo)TimestampTokenInfo.getTemplate().decode(new ByteArrayInputStream(ci.getContent().getContents()));
            }
            catch (InvalidBERException e) {
                e.printStackTrace();
                throw new ASN1Exception((Exception)((Object)e));
            }
        }
        return null;
    }

    public void setContentInfo(P7ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public void setStatusInfo(PKIStatusInfo statusInfo) {
        this.statusInfo = statusInfo;
    }

    public void decode(InputStream in, TransportEncodeFormat format) throws IOException {
        try {
            TimestampResponseInfo res;
            if (format.equals(TransportEncodeFormat.PEM)) {
                Base64InputStream b64In = new Base64InputStream(in);
                res = (TimestampResponseInfo)TimestampResponseInfo.getTemplate().decode(b64In);
            } else {
                res = (TimestampResponseInfo)TimestampResponseInfo.getTemplate().decode(in);
            }
            this.setStatusInfo(res.getStatusInfo());
            this.setContentInfo(res.getContentInfo());
        }
        catch (InvalidBERException e) {
            throw new TransportPackageEncodingFailException((Exception)((Object)e));
        }
    }

    public void encode(OutputStream out, TransportEncodeFormat format) throws IOException {
        if (format.equals(TransportEncodeFormat.PEM)) {
            PrintStream printer = new PrintStream(out);
            Base64OutputStream b64Out = new Base64OutputStream(printer, 16);
            this.encode(b64Out);
        } else {
            this.encode(out);
        }
    }

    public PKITrnsHeader getHeader() {
        return this.header;
    }

    public void setHeader(PKITrnsHeader header) {
        this.header = header;
    }

    public void setTrnsHeader(TransportHeader header) {
        this.header.setTrnsHeader(header);
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.statusInfo);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ TimestampResponseInfo(PKIStatusInfo pKIStatusInfo, P7ContentInfo p7ContentInfo, TimestampResponseInfo timestampResponseInfo) throws InvalidBERException {
        this(pKIStatusInfo, p7ContentInfo);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)PKIStatusInfo.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)P7ContentInfo.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            P7ContentInfo cinfo = null;
            if (seq.elementAt(1) != null) {
                cinfo = (P7ContentInfo)seq.elementAt(1);
            }
            return new TimestampResponseInfo((PKIStatusInfo)seq.elementAt(0), cinfo, null);
        }
    }
}

